<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class Ads extends CI_Controller {
 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Ads_model');
    }


   


function edit(){

    $ads_id='1';

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(empty($ads_id) || empty($ads_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Ads/edit'));
    }
    
    
    $data['menu'] = 'Ads Management';
    $data['smenu'] = 'Edit Ads';
    $data['pTitle'] = "Edit Ads";
    $data['pDescription'] = "Update Ads Data";
    $data['page'] = 'Ads/create';
    $data['ads_id'] = $ads_id;
    $data['adsData'] = $this->Ads_model->getAdsData($ads_id);
   
    $this->load->view('template',$data);
}


public function edit_Ads($ads_id='')
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');

    if(!isset($_POST) || empty($_POST) || empty($ads_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Ads'));
    }

    if(isset($_FILES['ads_pic']['name']) && !empty($_FILES['ads_pic']['name']))
    {

        $files = $_FILES;
        $cpt = count($_FILES['ads_pic']['name']);

        $_FILES['userfile']['name']= time().$files['ads_pic']['name'];
        $_FILES['userfile']['type']= $files['ads_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['ads_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['ads_pic']['error'];
        $_FILES['userfile']['size']= $files['ads_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/ads';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        if(!$upload_img){

            $this->session->set_flashdata('message', array('message' => $this->upload->display_errors(),'class' => 'danger'));
            
        } else{
            $uploading_file = $this->upload->data();
            $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
           
        }
        
        $adsData = array(
             'title' => $this->input->post('title'),
            'ads_pic' => $image_file);

        
        
    }else{
        $adsData = array(
              'title' => $this->input->post('title'));
            
    }

    
    $result = $this->Ads_model->update_ads($ads_id,$adsData);
    if($result)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully Updated.",'class' => 'success'));
       redirect(base_url().'Ads/edit');
       
       
   }else{
    $this->session->set_flashdata('message', array('message' => "Please try again.",'class' => 'danger'));
    
}



}





}
?>