<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class Amenities extends CI_Controller {
 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Amenities_model');
    }


    public function index()
    {


     $data['menu'] = 'Amenities Management';
     $data['smenu'] = 'View Amenities List';
     $data['pTitle'] = "Amenities Management";
     $data['pDescription'] = "View Amenities List";
     $data['page'] = 'amenities/list';
     $data['datatable'] = 1;
     $data['AmenitiesData']=$this->Amenities_model->getAmenitiesData();
     $this->load->view('template', $data);
    }



	public function create()
	{
   $data['menu'] = 'Amenities Management';
   $data['smenu'] = 'Add Amenities';
   $data['pTitle'] = "Amenities Management";
   $data['pDescription'] = "Add Amenities";
   $data['page'] = 'amenities/create';
   $this->load->view('template',$data);
	}

public function create_Amenities()
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Amenities/create'));
    }



    $err = 0;
    $errMsg = '';
    if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
        $err = 1;
        $errMsg = 'Provide a Amenities Name';
        
    } 


 
    if($err == 0){



       
        $AmenitiesData = array(
            'name' => $this->input->post('name')
        );
       
    }

    if($err == 1){
        $flashMsg['message'] = $errMsg;
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Amenities'));
    }



    $qry = $this->Amenities_model->add_Amenities($AmenitiesData);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully added.",'class' => 'success'));
       redirect(base_url().'Amenities');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }

 



 
}


function edit($Amenities_id=''){
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(empty($Amenities_id) || empty(decode_param($Amenities_id))){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Amenities/list'));
    }
    
    $data['menu'] = 'Amenities Management';
    $data['smenu'] = 'Edit Amenities';
    $data['pTitle'] = "Edit Amenities";
    $data['pDescription'] = "Update Amenities Data";
    $data['page'] = 'amenities/create';
    $data['Amenities_id'] = $Amenities_id;
    $data['AmenitiesData'] = $this->Amenities_model->getAmenitiesData(decode_param($Amenities_id));
   
    $this->load->view('template',$data);
}


public function edit_Amenities($Amenities_id='')
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');

    if(!isset($_POST) || empty($_POST) || empty($Amenities_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Amenities'));
    }

    
        $AmenitiesData = array(
             'name' => $this->input->post('name'));
            
 
    
    $result = $this->Amenities_model->update_Amenities(decode_param($Amenities_id),$AmenitiesData);
    if($result)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully Updated.",'class' => 'success'));
       redirect(base_url().'Amenities');
       
       
   }else{
    $this->session->set_flashdata('message', array('message' => "Please try again.",'class' => 'danger'));
    
}



}


function changeStatus($Amenities_id = '',$status ='1'){
        
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
        if(empty($Amenities_id) || !is_numeric($Amenities_id = decode_param($Amenities_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Amenities'));
        }
        $status = $this->Amenities_model->changeStatus($Amenities_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Amenities'));
    }





}
?>