<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Country extends CI_Controller {

  public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Country_model');
        $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

          
    }

public function index()
    {


     $data['menu'] = 'country Management';
     $data['smenu'] = 'View country List';
     $data['pTitle'] = "country Management";
     $data['pDescription'] = "View country List";
     $data['page'] = 'country/list';
     $data['datatable'] = 1;
     $data['countryData']=$this->Country_model->getcountryData();
//print_r($data['countryData']);exit;
     $this->load->view('template', $data);
 }

public function create()
 {

   $data['menu'] = 'country Management';
   $data['smenu'] = 'Add country';
   $data['pTitle'] = "country Management";
   $data['pDescription'] = "Add country";
   $data['page'] = 'country/create';
   $data['countryData'] = $this->Country_model->getcountryData();
   
   $this->load->view('template', $data);
}


	
public function create_country()
{
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('country/create'));
    }




    $err = 0;
    $errMsg = '';
    if($err == 0 && (!isset($_POST['country_name']) || empty($_POST['country_name']))){
        $err = 1;
        $errMsg = 'Provide a Country Name';
        
    } else if($err == 0 && (!isset($_POST['code']) || empty($_POST['code']))){
        
        $err = 1;
        $errMsg = 'Provide a Code';
        } else if($err == 0 && (!isset($_POST['symbol']) || empty($_POST['symbol']))){
        
        $err = 1;
        $errMsg = 'Provide a Symbol';
        } else if($err == 0 && (!isset($_POST['rate']) || empty($_POST['rate']))){
        
        $err = 1;
        $errMsg = 'Provide a Rate';
         } else if($err == 0 && (!isset($_POST['vat']) || empty($_POST['vat']))){ 
        
        $err = 1;
        $errMsg = 'Provide a VAT';
        } else if($err == 0 && (!isset($_FILES) || empty($_FILES) || 
        !isset($_FILES['flag']) || empty($_FILES['flag']))){
        $err = 1;
        $errMsg = 'Provide a Flag Image';
    } else if($err == 0 && (!isset($_POST['country_name_arab']) || empty($_POST['country_name_arab']))){
        $err = 1;
        $errMsg = 'Provide a country Name Arabic';
    } 




    if($err == 0){
  

   $files = $_FILES;
 
                    $cpt = count($_FILES['flag']['name']);

                    $_FILES['userfile']['name']= time().$files['flag']['name'];
                    $_FILES['userfile']['type']= $files['flag']['type'];
                    $_FILES['userfile']['tmp_name']= $files['flag']['tmp_name'];
                    $_FILES['userfile']['error']= $files['flag']['error'];
                    $_FILES['userfile']['size']= $files['flag']['size'];
                    $config = array();
                    $config['upload_path'] = './assets/uploads/flag';
                    $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
                    $config['max_size']      = '';
                    $config['overwrite']     = FALSE;
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                   $upload_img = $this->upload->do_upload();
                    $uploading_file = $this->upload->data();
        // $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
        //  $this->move_files($image_file);
        // $image_file ='assets/uploads/country/'.$uploading_file['file_name'];
            $img_file1 = $uploading_file['file_name'];
            // $new_array = array('width'=>100, 'height'=>100);
            // $img_file = imageResize($image, $new_array, './uploads/flag/');
            // unlink('./uploads/flag/'.$image);
            // move_files('/uploads/flag/'.$img_file);
             $image_file = 'assets/uploads/flag/'.$img_file1;
       
        
        $countryData = array('country_name' => $this->input->post('country_name'),
                              'country_name_arab' => $this->input->post('country_name_arab'),
                              'code' => $this->input->post('code'),
                              'symbol' => $this->input->post('symbol'),
                              'rate' => $this->input->post('rate'),
                              'flag' => $image_file,
                              'vat' => $this->input->post('vat'));


                            
                               

      
        
    }

    if($err == 1){
        $flashMsg['message'] = $errMsg;
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('country'));
    }



    $qry = $this->Country_model->add_country($countryData);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully added.",'class' => 'success'));
       redirect(base_url().'country');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }


 


 
}

	
function edit($country_id=''){
 
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(empty($country_id) || empty(decode_param($country_id))){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('country'));
    }
    $data['page'] = 'country/create';
    $data['menu'] = 'country Management';
    $data['smenu'] = 'Edit country';
    $data['pTitle'] = "Edit country";
    $data['pDescription'] = "Update country Data";

    $data['country_id'] = $country_id;
    $data['countryData'] = $this->Country_model->getcountryData(decode_param($country_id));
  
    $this->load->view('template',$data);
}



public function edit_country($country_id='')
	{

          $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');

    if(!isset($_POST) || empty($_POST) || empty($country_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('country'));
    }

 if(isset($_FILES['flag']['name']) && !empty($_FILES['flag']['name']))
                {

                    $files = $_FILES;
                    $cpt = count($_FILES['flag']['name']);

                    $_FILES['userfile']['name']= time().$files['flag']['name'];
                    $_FILES['userfile']['type']= $files['flag']['type'];
                    $_FILES['userfile']['tmp_name']= $files['flag']['tmp_name'];
                    $_FILES['userfile']['error']= $files['flag']['error'];
                    $_FILES['userfile']['size']= $files['flag']['size'];
                    $config = array();
                    $config['upload_path'] = './assets/uploads/flag';
                    $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
                    $config['max_size']      = '';
                    $config['overwrite']     = FALSE;
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    $upload_img = $this->upload->do_upload();
                    
                    if(!$upload_img){

                    	$this->session->set_flashdata('message', array('message' => $this->upload->display_errors(),'class' => 'danger'));
                       
                    } else{
                        $uploading_file = $this->upload->data();

                        // $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
                        // $this->move_files($image_file);
                        // $image_file ='assets/uploads/country/'.$uploading_file['file_name'];
                        $img_file1 = $uploading_file['file_name'];
            // $new_array = array('width'=>100, 'height'=>100);
            // $img_file = imageResize($image, $new_array, './uploads/flag/');
            //  unlink('./uploads/flag/'.$image);
            // move_files('/uploads/flag/'.$img_file);
            $image_file = 'assets/uploads/flag/'.$img_file1;
                    }
                
                    $countryData = array(
                        'country_name' => $this->input->post('country_name'),
                              'country_name_arab' => $this->input->post('country_name_arab'),
                              'code' => $this->input->post('code'),
                              'symbol' => $this->input->post('symbol'),
                              'rate' => $this->input->post('rate'),
                              'flag' => $image_file,
                              'vat' => $this->input->post('vat'));

                       
                    
                    }else{
                    $countryData = array(
                        'country_name' => $this->input->post('country_name'),
                              'country_name_arab' => $this->input->post('country_name_arab'),
                              'code' => $this->input->post('code'),
                              'symbol' => $this->input->post('symbol'),
                              'rate' => $this->input->post('rate'),
                              'vat' => $this->input->post('vat'));
                        
                        }

       
                     $result = $this->Country_model->update_country(decode_param($country_id),$countryData);
                    if($result)
                    {
                        
                         $this->session->set_flashdata('message', array('message' => "Successfully Updated.",'class' => 'success'));
                          redirect(base_url().'country');
                    	
                        
                    }else{
                    	$this->session->set_flashdata('message', array('message' => "Please try again.",'class' => 'danger'));
                        
                    }


 
}

public function delete($country_id='') {
    
    $result = $this->Country_model->delete_country(decode_param($country_id));
    $this->session->set_flashdata('message', array('message' => 'country Deleted Successfully','class' => 'success'));
    redirect(base_url().'country');
}





}
