<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Express extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Express_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'Express/list';
        $template['menu'] = 'Express Management';
        $template['smenu'] = 'View Expresss';
        $template['pTitle'] = "View Expresss";
        $template['pDescription'] = "View and Manage Expresss";
        $template['page_head'] = "Express Management";
        $template['datatable'] = 1;
        
		$this->load->view('template',$template);
	}
public function create(){
        
        $template['page'] = 'Express/create';
        $template['menu'] = 'Express Management';
        $template['smenu'] = 'Add Express';
        $template['pTitle'] = "Add Express";
        $template['pDescription'] = "Create New Express";
$template['services'] = $this->Express_model->getExpressServices();
$template['amenities'] = $this->Express_model->getAmenities();
        $this->load->view('template',$template);
    }

public function getExpressData(){
   
        $resArr = array('status'=>0);
        if(!isset($_POST)||empty($_POST)||!isset($_POST['express_id'])||empty($_POST['express_id']) || 
           !is_numeric($express_id = $_POST['express_id'])){
            echo json_encode($resArr);exit;
        }
         $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        
        $mechData = $this->Express_model->getExpressData($express_id,$view_all);
      
        if(empty($mechData)){
            echo json_encode($resArr);exit;
        }

        $resArr['status'] = 1;
        $resArr['data'] = $mechData;
        echo json_encode($resArr);exit;
    }





	function changeStatus($Express_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Express_id) || !is_numeric($Express_id = decode_param($Express_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Express'));
		}
		$status = $this->Express_model->changeStatus($Express_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Express'));
	}

	public function createExpress(){

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Express/create'));
		}
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Express Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Express Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Express Phone';
	
        }else if($err == 0 && (!isset($_POST['express_code']) || empty($_POST['express_code']))){
            $err = 1;
			$errMsg = 'Provide a Express Code';
        }
        
        if($err == 0){
	        $config = set_upload_service("assets/uploads/express");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	             $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
	            $image_file = $config['upload_path']."/".$upload_data['file_name'];
	          
             $_POST['profile_image'] = $image_file;
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Express/create'));
		}
		$temp_password = rand(10000000, 99999999);
		$_POST['password'] = md5($temp_password);

        $status = $this->Express_model->addExpress($_POST);

        if($status['status'] == 1){
		$profile_id =encode_param($status['profile_id']);	
$template = getNotifTemplate();
			$to =$_POST['email'];
                        $sender_email = "hello@access.sa";
                        $data['name']=$_POST['name'];
                        $data['email']=$_POST['email'];
                         $data['reg_url']=base_url('Registration_request/editExpresss/'.$profile_id);
                        
                        $data['registration_mail']=$template['registration_mail'];
                        $data['password']=$temp_password;
                        $mail_head = "Your Access Account is now activated";
                       
if(isset($template['registration_mail']) && !empty($template['registration_mail'])){

	                    
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Express Login', $this->load->view('template/mail_template/express_login_edit', $data,TRUE),'');


                       }else{
       
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Express Login', $this->load->view('template/mail_template/express_login', $data,TRUE),'');
             

                       }
                        
                    

            $flashMsg =array('message'=>'Successfully added..!','class'=>'success','Express_id'=>$status['Express_id']);
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/create'));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/create'));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/create'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/create'));
        }
	}
	public function editExpresss($Express_id){
       
		$id=decode_param($Express_id);
 
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Express_id) || !is_numeric($Express_id = decode_param($Express_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Express'));
		}

		$template['page'] = 'Express/create';
        $template['menu'] = 'Express Management';
        $template['smenu'] = 'Edit Express';
        $template['pTitle'] = "Edit Expresss";
        $template['pDescription'] = "Update Express Data";
         

        $template['ExpressData'] = $this->Express_model->getExpressData($id);
        $template['Express_id'] =encode_param($id);

		$this->load->view('template',$template);
	}

	public function updateExpress($Express_id = ''){
		$id=decode_param($Express_id);
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Express/create'));
		}
		
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Express Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Express Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Express Phone';
	
        }
    	
        if($err == 0){
	       $config = set_upload_service("assets/uploads/express");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('profile_image')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                 $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
                $image_file = $config['upload_path']."/".$upload_data['file_name'];
              
             $_POST['profile_image'] = $image_file;
            }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Express/editExpresss/'.$Express_id));
		}
		
        $status = $this->Express_model->updateExpress($id,$_POST);
       
        if($status == 1){
            $flashMsg = array('message'=>'Update Successfully!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
           redirect(base_url('Express'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/editExpresss/'.$Express_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/editExpresss/'.$Express_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/editExpresss/'.$Express_id));
        } 
        else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Express/editExpresss/'.$Express_id));
        }
	}



public function check_email_availability() {
   			
		$email=$this->input->post('email');
        $result = $this->Express_model->email_availability_check($email);
		echo json_encode($result);
	    }


public function get_all_Express() {
	$data = $_GET;
    
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];
    $columns = array("express.carrier_id","express.name","express.email_id","express.phone_no");
    $value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
          }



	$prod_list = $this->Express_model->get_all_Express($value);

    $all_list = $this->Express_model->get_all_Express();

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Express_model->get_all_Express($value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {


$action = "<a class='btn btn-info btn-sm view_wish' onclick='getExpressDetails(".$r->carrier_id.")'><i class='fa fa-fw fa-eye'></i>View</a>";

                $action .= "  <a class='btn btn-info btn-sm' href='".base_url()."Express/editExpresss/".encode_param($r->carrier_id)."'>
                                             <i class='fa fa-pencil'></i>Edit
                                         </a>";
                                  
                                      
                                               
                $action .=   "  <a class='btn btn-sm btn-danger' 
                            href='".base_url()."Express/changeStatus/".encode_param($r->carrier_id).'/2' ."'
                            onClick='return doconfirm()'>
                          <i class='fa fa-fw fa-trash'></i>Delete
                        </a>";   
                        
                       
                                        
                         if($r->status == 1){ 
                $action .=   " <a class='btn btn-sm btn-success' style='background-color:#ac2925' href='".base_url()."Express/changeStatus/".encode_param($r->carrier_id).'/0' ."'>
                                             <i class='fa fa-cog'></i> De-activate
                                           </a>";
                                         } else { 
                $action .=  " <a class='btn btn-sm btn-success' href='".base_url()."Express/changeStatus/".encode_param($r->carrier_id).'/1' ."'>
                       <i class='fa fa-cog'></i> Activate
                                </a>";
                        } 
                        


                array_push($data, array(
                    $r->carrier_id,
                    $r->name,
                    $r->email_id,
                    $r->phone_no,
                    $action
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}


	
}
?>