<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Garage extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Garage_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'garage/list';
        $template['menu'] = 'Garage Management';
        $template['smenu'] = 'View Garages';
        $template['pTitle'] = "View Garages";
        $template['pDescription'] = "View and Manage Garages";
        $template['page_head'] = "Garage Management";
        $template['datatable'] = 1;
        
		$this->load->view('template',$template);
	}
public function create(){
        
        $template['page'] = 'garage/create';
        $template['menu'] = 'Garage Management';
        $template['smenu'] = 'Add Garage';
        $template['pTitle'] = "Add Garage";
        $template['pDescription'] = "Create New Garage";
$template['services'] = $this->Garage_model->getGarageServices();
$template['amenities'] = $this->Garage_model->getAmenities();
//echo json_encode($template['amenities']);exit;
        $this->load->view('template',$template);
    }

public function getGarageData(){
   
        $resArr = array('status'=>0);
        if(!isset($_POST)||empty($_POST)||!isset($_POST['garage_id'])||empty($_POST['garage_id']) || 
           !is_numeric($garage_id = $_POST['garage_id'])){
            echo json_encode($resArr);exit;
        }
         $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
        $mechData = $this->Garage_model->getGarageData($garage_id,$view_all);

        if(empty($mechData)){
            echo json_encode($resArr);exit;
        }

        $resArr['status'] = 1;
        $resArr['data'] = $mechData;
        echo json_encode($resArr);exit;
    }





	function changeStatus($Garage_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Garage_id) || !is_numeric($Garage_id = decode_param($Garage_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Garage'));
		}
		$status = $this->Garage_model->changeStatus($Garage_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Garage'));
	}

	public function createGarage(){

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Garage/create'));
		}
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Garage Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Garage Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Garage Phone';
	
        }else if($err == 0 && (!isset($_POST['garage_code']) || empty($_POST['garage_code']))){
            $err = 1;
			$errMsg = 'Provide a Garage Code';
        }
        
        if($err == 0){
	        $config = set_upload_service("assets/uploads/Garage");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	             $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
	            $image_file = $config['upload_path']."/".$upload_data['file_name'];
	          
             $_POST['profile_image'] = $image_file;
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Garage/create'));
		}
		$temp_password = rand(10000000, 99999999);
		$_POST['password'] = md5($temp_password);

        $status = $this->Garage_model->addGarage($_POST);

        if($status['status'] == 1){
			     $profile_id =encode_param($status['profile_id']);
$template = getNotifTemplate();
			$to =$_POST['email'];
                        $sender_email = "hello@access.sa";
                        $data['name']=$_POST['name'];
                        $data['email']=$_POST['email'];
                        $data['reg_url']=base_url('Registration_request/editGarege/'.$profile_id);
                        $data['registration_mail']=$template['registration_mail'];
                        $data['password']=$temp_password;
                        $mail_head = "Your Access Account is now activated";
if(isset($template['registration_mail']) && !empty($template['registration_mail'])){

	                    
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Garage Login', $this->load->view('template/mail_template/Garage_login_edit', $data,TRUE),'');


                       }else{
       
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Garage Login', $this->load->view('template/mail_template/Garage_login', $data,TRUE),'');
             

                       }
                        
                    

            $flashMsg =array('message'=>'Successfully added..!','class'=>'success','Garage_id'=>$status['Garage_id']);
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/create'));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/create'));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/create'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/create'));
        }
	}
	public function editGarages($Garage_id){
       
		$id=decode_param($Garage_id);

		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Garage_id) || !is_numeric($Garage_id = decode_param($Garage_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Garage'));
		}

		$template['page'] = 'garage/create';
        $template['menu'] = 'Garage Management';
        $template['smenu'] = 'Edit Garage';
        $template['pTitle'] = "Edit Garages";
        $template['pDescription'] = "Update Garage Data";
        $template['services'] = $this->Garage_model->getGarageServices();
        $template['garageData'] = $this->Garage_model->getGarageData($id);
        $template['Garage_id'] =encode_param($id);
        $template['amenities'] = $this->Garage_model->getAmenities();
        $template['serviceData'] = $this->Garage_model->getServiceData($id);

		$this->load->view('template',$template);
	}

	public function updateGarage($Garage_id = ''){
		$id=decode_param($Garage_id);
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Garage/create'));
		}
		
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Garage Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Garage Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Garage Phone';
	
        }
    	
        if($err == 0){
	       $config = set_upload_service("assets/uploads/Garage");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('profile_image')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                 $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
                $image_file = $config['upload_path']."/".$upload_data['file_name'];
              
             $_POST['profile_image'] = $image_file;
            }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Garage/editGarages/'.$Garage_id));
		}
		
        $status = $this->Garage_model->updateGarage($id,$_POST);
       
        if($status == 1){
            $flashMsg = array('message'=>'Update Successfully!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
           redirect(base_url('Garage/editGarages/'.encode_param($id)));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/editGarages/'.$Garage_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/editGarages/'.$Garage_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/editGarages/'.$Garage_id));
        } 
        else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage/editGarages/'.$Garage_id));
        }
	}



public function check_email_availability() {
   			
		$email=$this->input->post('email');
        $result = $this->Garage_model->email_availability_check($email);
		echo json_encode($result);
	    }


public function get_all_Garage() {
	$data = $_GET;
    
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];
    $columns = array("garage.garage_id","garage.name","garage.email","garage.mobile");
    $value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
          }



	$prod_list = $this->Garage_model->get_all_Garage($value);

    $all_list = $this->Garage_model->get_all_Garage();

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Garage_model->get_all_Garage($value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {


$action = "<a class='btn btn-info btn-sm view_wish' onclick='getGarageDetails(".$r->garage_id.")'><i class='fa fa-fw fa-eye'></i>View</a>";

                $action .= "  <a class='btn btn-info btn-sm' href='".base_url()."Garage/editGarages/".encode_param($r->garage_id)."'>
                                             <i class='fa fa-pencil'></i>Edit
                                         </a>";
                                  
                                      
                                               
                $action .=   "  <a class='btn btn-sm btn-danger' 
                            href='".base_url()."Garage/changeStatus/".encode_param($r->garage_id).'/2' ."'
                            onClick='return doconfirm()'>
                          <i class='fa fa-fw fa-trash'></i>Delete
                        </a>";   
                        
                       
                                        
                         if($r->status == 1){ 
                $action .=   " <a class='btn btn-sm btn-success' style='background-color:#ac2925' href='".base_url()."Garage/changeStatus/".encode_param($r->garage_id).'/0' ."'>
                                             <i class='fa fa-cog'></i> De-activate
                                           </a>";
                                         } else { 
                $action .=  " <a class='btn btn-sm btn-success' href='".base_url()."Garage/changeStatus/".encode_param($r->garage_id).'/1' ."'>
                       <i class='fa fa-cog'></i> Activate
                                </a>";
                        } 
                        


                array_push($data, array(
                    $r->garage_id,
                    $r->name,
                    $r->email,
                    $r->phone_no,
                    $r->location,
                    $action
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}

}
?>