<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class Parts extends CI_Controller {
 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Parts_model');
    }


    public function index()
    {


     $data['menu'] = 'Parts Management';
     $data['smenu'] = 'View Parts List';
     $data['pTitle'] = "Parts Management";
     $data['pDescription'] = "View Parts List";
     $data['page'] = 'Parts/list';
     $data['datatable'] = 1;
     $data['PartsData']=$this->Parts_model->getPartsData();
     $this->load->view('template', $data);
    }



	public function create()
	{
   $data['menu'] = 'Parts Management';
   $data['smenu'] = 'Add Parts';
   $data['pTitle'] = "Parts Management";
   $data['pDescription'] = "Add Parts";
   $data['page'] = 'Parts/create';
   $this->load->view('template',$data);
	}

public function create_Parts()
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Parts/create'));
    }



    $err = 0;
    $errMsg = '';
    if($err == 0 && (!isset($_POST['part_name']) || empty($_POST['part_name']))){
        $err = 1;
        $errMsg = 'Provide a Part Name';
        
    } else if($err == 0 && (!isset($_FILES) || empty($_FILES) || 
        !isset($_FILES['Parts_pic']) || empty($_FILES['Parts_pic']))){
        $err = 1;
        $errMsg = 'Provide a Part Image';
    }


 
    if($err == 0){



        $files = $_FILES;
        $cpt = count($_FILES['Parts_pic']['name']);

        $_FILES['userfile']['name']= time().$files['Parts_pic']['name'];
        $_FILES['userfile']['type']= $files['Parts_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['Parts_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['Parts_pic']['error'];
        $_FILES['userfile']['size']= $files['Parts_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/parts';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        
        $uploading_file = $this->upload->data();
         $image = $uploading_file['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           

         $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
        

       
        $PartsData = array(
            'part_name' => $this->input->post('part_name'),
            'part_image' => $image_file
        );
       
    }

    if($err == 1){
        $flashMsg['message'] = $errMsg;
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Parts'));
    }



    $qry = $this->Parts_model->add_Parts($PartsData);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully added.",'class' => 'success'));
       redirect(base_url().'Parts');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }

 



 
}


function edit($Parts_id=''){
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(empty($Parts_id) || empty(decode_param($Parts_id))){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Parts/list'));
    }
    
    $data['menu'] = 'Parts Management';
    $data['smenu'] = 'Edit Parts';
    $data['pTitle'] = "Edit Parts";
    $data['pDescription'] = "Update Parts Data";
    $data['page'] = 'Parts/create';
    $data['Parts_id'] = $Parts_id;
    $data['PartsData'] = $this->Parts_model->getPartsData(decode_param($Parts_id));
   
    $this->load->view('template',$data);
}


public function edit_Parts($Parts_id='')
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');

    if(!isset($_POST) || empty($_POST) || empty($Parts_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Parts'));
    }

    if(isset($_FILES['Parts_pic']['name']) && !empty($_FILES['Parts_pic']['name']))
    {

        $files = $_FILES;
        $cpt = count($_FILES['Parts_pic']['name']);

        $_FILES['userfile']['name']= time().$files['Parts_pic']['name'];
        $_FILES['userfile']['type']= $files['Parts_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['Parts_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['Parts_pic']['error'];
        $_FILES['userfile']['size']= $files['Parts_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/parts';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        if(!$upload_img){

            $this->session->set_flashdata('message', array('message' => $this->upload->display_errors(),'class' => 'danger'));
            
        } else{
            $uploading_file = $this->upload->data();
            $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
           
        }
        
        $PartsData = array(
             'part_name' => $this->input->post('part_name'),
            'part_image' => $image_file);

        
        
    }else{
        $PartsData = array(
             'part_name' => $this->input->post('part_name'));
            
    }

    
    $result = $this->Parts_model->update_Parts(decode_param($Parts_id),$PartsData);
    if($result)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully Updated.",'class' => 'success'));
       redirect(base_url().'Parts');
       
       
   }else{
    $this->session->set_flashdata('message', array('message' => "Please try again.",'class' => 'danger'));
    
}



}


function changeStatus($Parts_id = '',$status ='1'){
        
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
        if(empty($Parts_id) || !is_numeric($Parts_id = decode_param($Parts_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Parts'));
        }
        $status = $this->Parts_model->changeStatus($Parts_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Parts'));
    }





}
?>