<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pos extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Pos_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }

	public function index(){
       
		$template['page'] = 'Pos/list';
        $template['menu'] = 'Pos Management';
        $template['smenu'] = 'View Pos';
        $template['pTitle'] = "View Pos";
        $template['pDescription'] = "View and Manage Pos";
        $template['page_head'] = "Pos Management";
        $template['datatable'] = 1;
        
		$this->load->view('template',$template);
	}
public function create(){
        
        $template['page'] = 'Pos/create';
        $template['menu'] = 'Pos Management';
        $template['smenu'] = 'Add Pos';
        $template['pTitle'] = "Add Pos";
        $template['pDescription'] = "Create New Pos";
        $template['services'] = $this->Pos_model->getPosServices();
        $template['amenities'] = $this->Pos_model->getAmenities();
        //echo json_encode($template['amenities']);exit;
        $this->load->view('template',$template);
    }

public function getPosData(){
   
        $resArr = array('status'=>0);
        if(!isset($_POST)||empty($_POST)||!isset($_POST['pos_id'])||empty($_POST['pos_id']) || 
           !is_numeric($pos_id = $_POST['pos_id'])){
            echo json_encode($resArr);exit;
        }
         $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
        $mechData = $this->Pos_model->getPosData($pos_id,$view_all);
      //echo json_encode($mechData);exit;
        if(empty($mechData)){
            echo json_encode($resArr);exit;
        }

        $resArr['status'] = 1;
        $resArr['data'] = $mechData;
        echo json_encode($resArr);exit;
    }





	function changeStatus($Pos_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Pos_id) || !is_numeric($Pos_id = decode_param($Pos_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Pos'));
		}
		$status = $this->Pos_model->changeStatus($Pos_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Pos'));
	}

	public function createPos(){

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Pos/create'));
		}
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Pos Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Pos Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Pos Phone';
	
        }else if($err == 0 && (!isset($_POST['Pos_code']) || empty($_POST['Pos_code']))){
            $err = 1;
			$errMsg = 'Provide a Pos Code';
        }
        
        if($err == 0){
	        $config = set_upload_service("assets/uploads/Pos");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	             $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
	            $image_file = $config['upload_path']."/".$upload_data['file_name'];
	          
             $_POST['profile_image'] = $image_file;
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Pos/create'));
		}
		$temp_password = rand(10000000, 99999999);
		$_POST['password'] = md5($temp_password);

        $status = $this->Pos_model->addPos($_POST);

        if($status['status'] == 1){
		$profile_id =encode_param($status['profile_id']);	
$template = getNotifTemplate();
			$to =$_POST['email'];
                        $sender_email = "hello@access.sa";
                        $data['name']=$_POST['name'];
                        $data['email']=$_POST['email'];
                        $data['reg_url']=base_url('Registration_request/editPos/'.$profile_id);
                        $data['registration_mail']=$template['registration_mail'];
                        $data['password']=$temp_password;
                        $mail_head = "Your Access Account is now activated";
if(isset($template['registration_mail']) && !empty($template['registration_mail'])){

	                    
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Pos Login', $this->load->view('template/mail_template/Pos_login_edit', $data,TRUE),'');


                       }else{
       
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Pos Login', $this->load->view('template/mail_template/Pos_login', $data,TRUE),'');
             

                       }
                        
                    

            $flashMsg =array('message'=>'Successfully added..!','class'=>'success','Pos_id'=>$status['Pos_id']);
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/create'));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/create'));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/create'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/create'));
        }
	}
	public function editPos($Pos_id){
       
		$id=decode_param($Pos_id);
 
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Pos_id) || !is_numeric($Pos_id = decode_param($Pos_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Pos'));
		}

		$template['page'] = 'Pos/create';
        $template['menu'] = 'Pos Management';
        $template['smenu'] = 'Edit Pos';
        $template['pTitle'] = "Edit Pos";
        $template['pDescription'] = "Update Pos Data";
         

        $template['PosData'] = $this->Pos_model->getPosData($id);
        $template['Pos_id'] =encode_param($id);

		$this->load->view('template',$template);
	}

	public function updatePos($Pos_id = ''){
		$id=decode_param($Pos_id);
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Pos/create'));
		}
		
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Pos Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Pos Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Pos Phone';
	
        }
    
        if($err == 0){
	        $config = set_upload_service("assets/uploads/Pos");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('profile_image')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                 $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
                $image_file = $config['upload_path']."/".$upload_data['file_name'];
              
             $_POST['profile_image'] = $image_file;
            }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Pos/editPos/'.$Pos_id));
		}
		
        $status = $this->Pos_model->updatePos($id,$_POST);
       
        if($status == 1){
            $flashMsg = array('message'=>'Update Successfully!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
           redirect(base_url('Pos'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/editPos/'.$Pos_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/editPos/'.$Pos_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/editPos/'.$Pos_id));
        } 
        else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Pos/editPos/'.$Pos_id));
        }
	}



public function check_email_availability() {
   			
		$email=$this->input->post('email');
        $result = $this->Pos_model->email_availability_check($email);
		echo json_encode($result);
	    }


public function get_all_Pos() {
	$data = $_GET;
    
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];
    $columns = array("pos.Pos_id","pos.name","pos.email","pos.mobile");
    $value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
          }



	$prod_list = $this->Pos_model->get_all_Pos($value);
//echo json_encode($prod_list);exit;
    $all_list = $this->Pos_model->get_all_Pos();

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Pos_model->get_all_Pos($value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {


$action = "<a class='btn btn-info btn-sm view_wish' onclick='getPosDetails(".$r->pos_id.")'><i class='fa fa-fw fa-eye'></i>View</a>";

                $action .= "  <a class='btn btn-info btn-sm' href='".base_url()."Pos/editPos/".encode_param($r->pos_id)."'>
                                             <i class='fa fa-pencil'></i>Edit
                                         </a>";
                                  
                                      
                                               
                $action .=   "  <a class='btn btn-sm btn-danger' 
                            href='".base_url()."Pos/changeStatus/".encode_param($r->pos_id).'/2' ."'
                            onClick='return doconfirm()'>
                          <i class='fa fa-fw fa-trash'></i>Delete
                        </a>";   
                        
                       
                                        
                         if($r->status == 1){ 
                $action .=   " <a class='btn btn-sm btn-success' style='background-color:#ac2925' href='".base_url()."Pos/changeStatus/".encode_param($r->pos_id).'/0' ."'>
                                             <i class='fa fa-cog'></i> De-activate
                                           </a>";
                                         } else { 
                $action .=  " <a class='btn btn-sm btn-success' href='".base_url()."Pos/changeStatus/".encode_param($r->pos_id).'/1' ."'>
                       <i class='fa fa-cog'></i> Activate
                                </a>";
                        } 
                        


                array_push($data, array(
                    $r->pos_id,
                    $r->name,
                    $r->email_id,
                    $r->phone_no,
                    $action
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}


	
}
?>