<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pos_booking extends CI_Controller {

 	public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Pos_booking_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }

	public function index(){
       
		$template['page'] = 'Pos_booking/list';
        $template['menu'] = 'Service Booking Management';
        $template['smenu'] = 'View Service Booking';
        $template['pTitle'] = "View Service Booking";
        $template['pDescription'] = "View and Manage Service Booking";
        $template['page_head'] = "Service Booking Management";
        $template['datatable'] = 1;
		$this->load->view('template',$template);
	}

	public function get_all_Pos_booking() {
		$data = $_GET;
		$col = $data['order'][0]['column'];
		$col_type = $data['order'][0]['dir'];
		$columns = array("pos_booking.book_id","customer.name","customer.phone_no","pos_parts.unique_name","pos.name","pos.phone_no","customer_address.name","customer_address.phone_no","customer_address.house_no","customer_address.area","customer_address.country","customer_address.city");
		$value['order_by'] = $columns[$col];
		$value['order_type'] = $col_type;
		$value['search'] = $data['search']['value'];
		$value['start'] = $data['start'];
		$value['length'] = $data['length'];
		$value['where'] = '';
		if(!empty($value['search'])) {
	        $where = array();
	        foreach($columns as $c) {
	            $where_data[] = $c." like '%".$value['search']."%' ";
	        }
	        $where = implode(" OR ", $where_data);
	        $where = "(".$where.")";
	        $value['where'] = $where;
	    }
		$book_list = $this->Pos_booking_model->get_all_Pos_booking($value);
	    $all_list = $this->Pos_booking_model->get_all_Pos_booking();
		$recordsTotal = count($all_list);
	    $filtered = count($all_list);
	    if($value['where']!='') {
	        $value['length'] = '-1';
	        $all_list = $this->Pos_booking_model->get_all_Pos_booking($value);
	        $filtered = count($all_list);
	    }
		$data = array();
		foreach ($book_list  as $r) {
	        $action = $status = '';
			$action .= "<a class='btn btn-info btn-sm view_wish' onclick='getBookDetails(".$r->id.")'><i class='fa fa-fw fa-eye'></i>View</a>";
			if($r->status == 2){ 
				$status =   "<button type='button' class='btn btn-primary'>Order Packed</button>";
			} else if ($r->status == 3) {
				$status =  "<button type='button' class='btn btn-success'>Order Delivered</button>";
			} else if ($r->status == 4) {
				$status =  "<button type='button' class='btn btn-success'>Completed</button>";
			} else if ($r->status == 0) {
				$status =  "<button type='button' class='btn btn-danger'>Cancelled</button>";
	    	} else if ($r->status == 1) {
				$status =  "<button type='button' class='btn btn-secondary'>New Booking</button>";
	    	}
	        array_push($data, array(
	            $r->cust_id,
	            $r->book_id,
	            $r->customer_name,
	            $r->customer_phone, 
	            $r->cost,
	            (isset($r->est_delivery) && !empty($r->est_delivery))?$r->est_delivery:'--',
	            $status,
	            $action
	        ));
	    }
		echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
	}

	public function getbookDetails(){
		$resArr = array('status'=>"error");
	   	if(!isset($_POST)||empty($_POST)||!isset($_POST['bookId'])||empty($_POST['bookId'])){
	     	echo json_encode($resArr);exit;
	   	}
	  
	   	$posData = $this->Pos_booking_model->getbookdetails($_POST['bookId']);
	    
	   	if(empty($posData)){
	     	echo json_encode($resArr);exit;
	   	}
	   	$resArr['status'] = 1;
	   	$resArr['data'] = $posData;
	   	echo json_encode($resArr);exit;
	}

	public function changeOrderStatus(){
		$resArr = array('status'=>"error");
	   	if(!isset($_POST)||empty($_POST)||!isset($_POST['bookingId'])||empty($_POST['bookingId']) || !isset($_POST['status'])||empty($_POST['status']) || !isset($_POST['expected_date'])||empty($_POST['expected_date'])){
	     	echo json_encode($resArr);exit;
	   	}
	   	$posData = $this->Pos_booking_model->changeOrderStatus($_POST);
	   	if(empty($posData)){
	     	echo json_encode($resArr);exit;
	   	}
	   	$resArr['status'] = 1;
	   	echo json_encode($resArr);exit;
	}	
}
?>