<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pos_parts extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Posparts_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'Posparts/list';
        $template['menu'] = 'Posparts Management';
        $template['smenu'] = 'View Posparts';
        $template['pTitle'] = "View Posparts";
        $template['pDescription'] = "View and Manage Posparts";
        $template['page_head'] = "Posparts Management";
        $template['datatable'] = 1;
        
		$this->load->view('template',$template);
	}
public function create(){
        
        $template['page'] = 'Posparts/create';
        $template['menu'] = 'Posparts Management';
        $template['smenu'] = 'Add Posparts';
        $template['pTitle'] = "Add Posparts";
        $template['pDescription'] = "Create New Posparts";
        $template['pos_data'] = $this->Posparts_model->getPosdata();
        $template['part_data'] = $this->Posparts_model->getPartdata();
    //print_r($template['part_data']);exit;
        $template['amenities'] = $this->Posparts_model->getAmenities();

        $this->load->view('template',$template);
    }

public function getPospartsData(){
    
        if(!isset($_POST)||empty($_POST)||!isset($_POST['Posparts_id'])||empty($_POST['Posparts_id']) || 
           !is_numeric($Posparts_id = $_POST['Posparts_id'])){
              $resArr = array('status'=>0);
            echo json_encode($resArr);exit;
        }
         $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
       
        $mechData = $this->Posparts_model->getPospartsData($Posparts_id,$view_all);
    
        if(!empty($mechData)){
            $resArr['status'] = 1;
        $resArr['data'] = $mechData;
        echo json_encode($resArr);exit;
             
        }
 $resArr = array('status'=>0);
            echo json_encode($resArr);exit;
        
    }





	function changeStatus($Posparts_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Posparts_id) || !is_numeric($Posparts_id = decode_param($Posparts_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Posparts'));
		}
		$status = $this->Posparts_model->changeStatus($Posparts_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Posparts'));
	}
public function createPosparts()
{
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Pos_parts/create'));
    }



    $err = 0;
    $errMsg = '';
   if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Pos_parts/create'));
        }
        if($err == 0 && (!isset($_POST['pos_id']) || empty($_POST['pos_id']))){
            $err = 1;
            $errMsg = 'Provide POS';
        }else if($err == 0 && (!isset($_POST['parts_id']) || empty($_POST['parts_id']))){
            $err = 1;
            $errMsg = 'Provide Parts';
        }else if($err == 0 && (!isset($_POST['part_number']) || empty($_POST['part_number']))){
            $err = 1;
            $errMsg = 'Provide Part Number';

        }else if($err == 0 && (!isset($_POST['unique_name']) || empty($_POST['unique_name']))){
            $err = 1;
            $errMsg = 'Provide unique Name';
        }
        


 
    if($err == 0){
     $Posparts = array(
            'pos_id' => $this->input->post('pos_id'),
             'part_id' => $this->input->post('parts_id'),
              'part_number' => $this->input->post('part_number'),
               'unique_name' => $this->input->post('unique_name'),
                'price' => $this->input->post('price'),
                 'quantity' => $this->input->post('quantity')
        );
       
    }

  


    $qry = $this->Posparts_model->addPosparts($Posparts);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully added.",'class' => 'success'));
       redirect(base_url().'Pos_parts');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }

 



 
}

	
	public function editPosparts($Posparts_id){
       
		$id=decode_param($Posparts_id);
 
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Posparts_id) || !is_numeric($Posparts_id = decode_param($Posparts_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Posparts'));
		}

		$template['page'] = 'Posparts/create';
        $template['menu'] = 'Posparts Management';
        $template['smenu'] = 'Edit Posparts';
        $template['pTitle'] = "Edit Posparts";
        $template['pDescription'] = "Update Posparts Data";
         
$template['pos_data'] = $this->Posparts_model->getPosdata();
//print_r($template['pos_data']);exit;
        $template['part_data'] = $this->Posparts_model->getPartdata();
        $template['PospartsData'] = $this->Posparts_model->getPospartsData($id);
        //print_r($template['PospartsData']->unique_name);exit;
        $template['Posparts_id'] =encode_param($id);

		$this->load->view('template',$template);
	}

	

public function updatePosparts($pospart_id = '')
{
    $id=decode_param($pospart_id);
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Pos_parts'));
    }



    $err = 0;
    $errMsg = '';
   if(!isset($_POST) || empty($_POST)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Pos_parts/create'));
        }
        if($err == 0 && (!isset($_POST['pos_id']) || empty($_POST['pos_id']))){
            $err = 1;
            $errMsg = 'Provide POS';
        }else if($err == 0 && (!isset($_POST['parts_id']) || empty($_POST['parts_id']))){
            $err = 1;
            $errMsg = 'Provide Parts';
        }else if($err == 0 && (!isset($_POST['part_number']) || empty($_POST['part_number']))){
            $err = 1;
            $errMsg = 'Provide Part Number';

        }else if($err == 0 && (!isset($_POST['unique_name']) || empty($_POST['unique_name']))){
            $err = 1;
            $errMsg = 'Provide unique Name';
        }
        


 
    if($err == 0){
     $Posparts = array(
            'pos_id' => $this->input->post('pos_id'),
             'part_id' => $this->input->post('parts_id'),
              'part_number' => $this->input->post('part_number'),
               'unique_name' => $this->input->post('unique_name'),
                'price' => $this->input->post('price'),
                 'quantity' => $this->input->post('quantity')
        );
       
    }

  

    $qry = $this->Posparts_model->updatePosparts($id,$Posparts);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully updated.",'class' => 'success'));
       redirect(base_url().'Pos_parts');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }

 



 
}

    

public function check_email_availability() {
   			
		$email=$this->input->Pospartst('email');
        $result = $this->Posparts_model->email_availability_check($email);
		echo json_encode($result);
	    }


public function get_all_Posparts() {
	$data = $_GET;
    
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];
    $columns = array("pos_parts.id","pos.name","parts.part_name","pos_parts.part_number","pos_parts.unique_name","pos_parts.price","pos_parts.quantity");
    $value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
          }



	$prod_list = $this->Posparts_model->get_all_Posparts($value);
    
    $all_list = $this->Posparts_model->get_all_Posparts();
	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Posparts_model->get_all_Posparts($value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {


$action = "<a class='btn btn-info btn-sm view_wish' onclick='getPospartsDetails(".$r->id.")'><i class='fa fa-fw fa-eye'></i>View</a>";

$action .= "  <a class='btn btn-info btn-sm' href='".base_url()."Pos_parts/editPosparts/".encode_param($r->id)."'>
                                             <i class='fa fa-pencil'></i>Edit
                                         </a>";
                                  
                                      
$action .=   "  <a class='btn btn-sm btn-danger' 
                            href='".base_url()."Pos_parts/changeStatus/".encode_param($r->id).'/2' ."'
                            onClick='return doconfirm()'>
                          <i class='fa fa-fw fa-trash'></i>Delete
                        </a>";   
                        
                       
                     
                        


                array_push($data, array(  
                    $r->pos_name,
                    $r->part_name,
                    $r->part_number,
                    $r->unique_name,
                    $r->price,
                    $r->quantity,
                    $action
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}


	
}
?>