<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pos_request extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Pos_request_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'Pos_request/list';
        $template['menu'] = 'Pos Requet Management';
        $template['smenu'] = 'View Pos Requests';
        $template['pTitle'] = "View Pos Requests";
        $template['pDescription'] = "View and Manage Pos Requests";
        $template['page_head'] = "Pos Request Management";
        $template['datatable'] = 1;
        //$template['Pos_request_data'] = $this->Pos_request_model->getPos_requestData();

		$this->load->view('template',$template);
	}

	public function getPos_requestData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['Pos_request_id'])||empty($_POST['Pos_request_id']) 
			|| !is_numeric($Pos_request_id = $_POST['Pos_request_id'])){
			echo json_encode($resArr);exit;
		}
		 $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
		$mechData = $this->Pos_request_model->getPos_requestData($Pos_request_id,$view_all);
      //echo json_encode($mechData);exit;
		if(empty($mechData)){
			echo json_encode($resArr);exit;
		}

		$resArr['status'] = 1;
		$resArr['data'] = $mechData;
		echo json_encode($resArr);exit;
	}

	function changeStatus($Pos_request_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Pos_request_id) || !is_numeric($Pos_request_id = decode_param($Pos_request_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Pos_request'));
		}
		$status = $this->Pos_request_model->changeStatus($Pos_request_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Pos_request'));
	}

	
	

	


public function check_email_availability() {
   			
		$email=$this->input->post('email');

        $result = $this->Pos_request_model->email_availability_check($email);
		echo json_encode($result);
		
		
	}


public function get_all_Pos_request() {
	$data = $_GET;
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];

	 $columns = array("pos_request.posReq_id","customer_address.name","customer_address.phone_no","pos_parts.unique_name","customer_address.house_no","customer_address.area","customer_address.country","customer_address.district","customer_address.city","customer.name","customer.phone_no");
	
	$value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
        $where = array();
        foreach($columns as $c) {
            $where_data[] = $c." like '%".$value['search']."%' ";
        }
        $where = implode(" OR ", $where_data);
        $where = "(".$where.")";
        $value['where'] = $where;
    }
	$prod_list = $this->Pos_request_model->get_all_Pos_request($value);
   
    $all_list = $this->Pos_request_model->get_all_Pos_request();
	//pr($all_list);exit;

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Pos_request_model->get_all_Pos_request($value);
        $filtered = count($all_list);
    }
	$data = array();
	foreach ($prod_list  as $r) {
    $assign_dt2 = $assign_dtl = $status = '';
		if($r->status == 1){ 
			$status =   "<button type='button' class='btn btn-primary'>Requested</button>";
		} else if ($r->status == 2) {                   
			$status =  "<button type='button' class='btn btn-info'>Assigned to POS</button>";
		} else if ($r->status == 3) {
			$status =  "<button type='button' class='btn btn-warning'>Accepted</button>";
		} else if ($r->status == 4) {
			$status =  "<button type='button' class='btn'>Quote Send</button>";
		} else if ($r->status == 5) {
			$status =  "<button type='button' class='btn btn-success'>Response From Pos</button>";
		}else if ($r->status == 0) {
			$status =  "<button type='button' class='btn btn-danger'>Cancelled</button>";
    }

		$action = "<a class='btn btn-info btn-sm view_wish' onclick='getPos_requestDetails(".$r->id.")'><i class='fa fa-fw fa-eye'></i>View</a>";

		
		$assign_dtl = "<a class='btn btn-info btn-sm' href='".base_url()."Pos_request/pos_assign/".encode_param($r->posReq_id)."'><i class='fa fa-pencil'></i>Assign</a>";

		   
		if($r->status == 5 || $r->status == 4) {
			$assign_dt2.= "<a class='btn btn-info btn-sm' href='".base_url()."Pos_response/responce/".encode_param($r->posReq_id)."'><i class='fa fa-pencil'></i>Responses</a>";
		}                           
        array_push($data, array(
            $r->cust_id,
            $r->posReq_id,
            $r->customer_name,
            $r->customer_phone,
            $r->unique_name,
            $r->name.', '.$r->house_no.', '.$r->phone_no.', '.$r->area.', '.$r->city,
            $status,
            $action .' '. $assign_dtl .' '. $assign_dt2 
            )
    	);
    }
	echo json_encode(array('recordsFiltered'=>$filtered,'recordsTotal'=>$recordsTotal,'data'=>$data));
}


public function getPosData($request_id = ''){
   $resArr = array('status'=>0);
   if(!isset($_POST)||empty($_POST)||!isset($_POST['request_id'])||empty($_POST['request_id']) || 
      !is_numeric($request_id = $_POST['request_id'])){
     echo json_encode($resArr);exit;
   }
  
   $posData = $this->Pos_request_model->getPosData($request_id,'');
   $assignPos = $this->Pos_request_model->getAssignPos($posData->posReq_id);
    
   if(empty($posData)){
     echo json_encode($resArr);exit;
   }
   $resArr['status'] = 1;
   $resArr['data'] = $posData;
   $resArr['assignPos'] = $assignPos;
   echo json_encode($resArr);exit;
}  

public function pos_assign($request_id=''){
	$template['page'] = 'Pos_request/assign';
    $template['menu'] = 'Pos Assign Management';
    $template['smenu'] = 'View Pos Assign';
    $template['pTitle'] = "View Pos Assign";
    $template['pDescription'] = "View and Manage Pos Assign";
    $template['page_head'] = "Pos Assign Management";
    $template['datatable'] = 1;
    $template['request_id'] = $request_id;
    $template['requestData'] = $this->Pos_request_model->getPosData('',decode_param($request_id));
    $template['posData'] = $this->Pos_request_model->getPosDetails(decode_param($request_id));
    $template['assign_pos'] = $this->Pos_request_model->getAssignPos(decode_param($request_id));
    //pr($template);
	$this->load->view('template',$template);
}

public function assign_pos(){
    if(!isset($_POST)||empty($_POST)){
      $resArr = array('status'=>0);
      echo json_encode($resArr);exit;
    }
    $posStatus = $this->Pos_request_model->assign_pos($_POST);  
    if(empty($posStatus)){
      echo json_encode(array('status'=>0));exit;
    }
    echo json_encode(array('status'=>1));exit;
}


	
}
?>