<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Road_assist extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Road_assist_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'Road_assist/list';
        $template['menu'] = 'Road_assist Management';
        $template['smenu'] = 'View Roadassist';
        $template['pTitle'] = "View Roadassist";
        $template['pDescription'] = "View and Manage Roadassist";
        $template['page_head'] = "Roadassist Management";
        $template['datatable'] = 1;
        
		$this->load->view('template',$template);
	}
public function create(){
        
        $template['page'] = 'Road_assist/create';
        $template['menu'] = 'Road_assist Management';
        $template['smenu'] = 'Add Roadassist';
        $template['pTitle'] = "Add Roadassist";
        $template['pDescription'] = "Create New Roadassist";

        $template['services'] = $this->Road_assist_model->getRoad_assistServices();
        $template['amenities'] = $this->Road_assist_model->getAmenities();
//echo json_encode($template['amenities']);exit;
        $this->load->view('template',$template);
    }

public function getRoad_assistData(){
   
        $resArr = array('status'=>0);
        if(!isset($_POST)||empty($_POST)||!isset($_POST['assist_id'])||empty($_POST['assist_id']) || 
           !is_numeric($assist_id = $_POST['assist_id'])){
            echo json_encode($resArr);exit;
        }
         $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
        $mechData = $this->Road_assist_model->getRoad_assistData($assist_id,$view_all);
      
        if(empty($mechData)){
            echo json_encode($resArr);exit;
        }

        $resArr['status'] = 1;
        $resArr['data'] = $mechData;
        echo json_encode($resArr);exit;
    }





	function changeStatus($road_assist_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($road_assist_id) || !is_numeric($road_assist_id = decode_param($road_assist_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Road_assist'));
		}
		$status = $this->Road_assist_model->changeStatus($road_assist_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Road_assist'));
	}

	public function createRoad_assist(){

		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Road_assist/create'));
		}
		if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
			$err = 1;
			$errMsg = 'Provide Road_assist Name';
		}else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
			$err = 1;
			$errMsg = 'Provide a Road_assist Email';
		}else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
			$err = 1;
			$errMsg = 'Provide Road_assist Phone';
	
        }else if($err == 0 && (!isset($_POST['road_assist_code']) || empty($_POST['road_assist_code']))){
            $err = 1;
			$errMsg = 'Provide a Road_assist Code';
        }
        
        if($err == 0){
	        $config = set_upload_service("assets/uploads/Road_assist");
	        $this->load->library('upload');
	        $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
	        $this->upload->initialize($config);
	        if(!$this->upload->do_upload('profile_image')){
	        	$err = 1;
				$errMsg = $this->upload->display_errors();
	        }else{
	            $upload_data = $this->upload->data();
	             $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
	            $image_file = $config['upload_path']."/".$upload_data['file_name'];
	          
             $_POST['profile_image'] = $image_file;
	        }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Road_assist/create'));
		}
		$temp_password = rand(10000000, 99999999);
		$_POST['password'] = md5($temp_password);

        $status = $this->Road_assist_model->addRoad_assist($_POST);

        if($status['status'] == 1){
			
$template = getNotifTemplate();
			$to =$_POST['email'];
                        $sender_email = "hello@access.sa";
                        $data['name']=$_POST['name'];
                        $data['email']=$_POST['email'];
                        $data['registration_mail']=$template['registration_mail'];
                        $data['password']=$temp_password;
                        $mail_head = "Your Access Account is now activated";
if(isset($template['registration_mail']) && !empty($template['registration_mail'])){

	                    
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Road assist Login', $this->load->view('template/mail_template/road_assist_login_edit', $data,TRUE),'');


                       }else{
       
                 $mail_status = send_custom_email($sender_email,$mail_head,$to,'Road assist Login', $this->load->view('template/mail_template/road_assist_login', $data,TRUE),'');
             

                       }
                        
                    

            $flashMsg =array('message'=>'Successfully added..!','class'=>'success','road_assist_id'=>$status['road_assist_id']);
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/create'));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/create'));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/create'));
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/create'));
        }
	}
	public function editRoad_assist($road_assist_id){
       
		$id=decode_param($road_assist_id);
 
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($road_assist_id) || !is_numeric($road_assist_id = decode_param($road_assist_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Road_assist'));
		}
		$template['page'] = 'Road_assist/create';
        $template['menu'] = 'Road_assist Management';
        $template['smenu'] = 'Edit Roadassist';
        $template['pTitle'] = "Edit Roadassist";
        $template['pDescription'] = "Update Roadassist Data";
         $template['services'] = $this->Road_assist_model->getGarageServices();
        $template['Road_assistData'] = $this->Road_assist_model->getRoad_assistData($id);
        $template['road_assist_id'] =encode_param($id);
         $template['serviceData'] = $this->Road_assist_model->getServiceData($id);
		$this->load->view('template',$template);
	}

	public function updateRoad_assist($road_assist_id = ''){
		$id=decode_param($road_assist_id);
		$err = 0;
		$errMsg = '';
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Road_assist/create'));
        }
        if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
            $err = 1;
            $errMsg = 'Provide Road assist Name';
        }else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
            $err = 1;
            $errMsg = 'Provide a Road assist Email';
        }else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
            $err = 1;
            $errMsg = 'Provide Road assist Phone';
    
        }else if($err == 0 && (!isset($_POST['road_assist_code']) || empty($_POST['road_assist_code']))){
            $err = 1;
            $errMsg = 'Provide a Road assist Code';
        }
    	
        if($err == 0){
	        $config = set_upload_service("assets/uploads/Road_assist");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('profile_image')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                 $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
                $image_file = $config['upload_path']."/".$upload_data['file_name'];
              
             $_POST['profile_image'] = $image_file;
            }
	    }

		if($err == 1){
			$flashMsg['message'] = $errMsg;
			$this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Road_assist/editRoad_assist/'.$road_assist_id));
		}
		
        $status = $this->Road_assist_model->updateRoad_assist($id,$_POST);
       
        if($status == 1){
            $flashMsg = array('message'=>'Update Successfully!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
           redirect(base_url('Road_assist'));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/editRoad_assist/'.$road_assist_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/editRoad_assist/'.$road_assist_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/editRoad_assist/'.$road_assist_id));
        } 
        else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Road_assist/editRoad_assist/'.$road_assist_id));
        }
	}



public function check_email_availability() {
   			
		$email=$this->input->Road_assistt('email');
        $result = $this->Road_assist_model->email_availability_check($email);
		echo json_encode($result);
	    }


public function get_all_Road_assist() {
	$data = $_GET;
    
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];
    $columns = array("road_assist.road_assist_id","road_assist.name","road_assist.email","road_assist.mobile");
    $value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
          }



	$prod_list = $this->Road_assist_model->get_all_Road_assist($value);
//echo json_encode($prod_list);exit;
    $all_list = $this->Road_assist_model->get_all_Road_assist();

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Road_assist_model->get_all_Road_assist($value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {


$action = "<a class='btn btn-info btn-sm view_wish' onclick='getRoad_assistDetails(".$r->road_assist_id.")'><i class='fa fa-fw fa-eye'></i>View</a>";

                $action .= "  <a class='btn btn-info btn-sm' href='".base_url()."Road_assist/editRoad_assist/".encode_param($r->road_assist_id)."'>
                                             <i class='fa fa-pencil'></i>Edit
                                         </a>";
                                  
                                      
                                               
                $action .=   "  <a class='btn btn-sm btn-danger' 
                            href='".base_url()."Road_assist/changeStatus/".encode_param($r->road_assist_id).'/2' ."'
                            onClick='return doconfirm()'>
                          <i class='fa fa-fw fa-trash'></i>Delete
                        </a>";   
                        
                       
                                        
                         if($r->status == 1){ 
                $action .=   " <a class='btn btn-sm btn-success' style='background-color:#ac2925' href='".base_url()."Road_assist/changeStatus/".encode_param($r->road_assist_id).'/0' ."'>
                                             <i class='fa fa-cog'></i> De-activate
                                           </a>";
                                         } else { 
                $action .=  " <a class='btn btn-sm btn-success' href='".base_url()."Road_assist/changeStatus/".encode_param($r->road_assist_id).'/1' ."'>
                       <i class='fa fa-cog'></i> Activate
                                </a>";
                        } 
                        


                array_push($data, array(
                    $r->road_assist_id,
                    $r->name,
                    $r->email_id,
                    $r->phone_no,
                    $action
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}


	
}
?>