<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Service_request extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Service_request_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_in')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'Service_request/list';
        $template['menu'] = 'Service Request Management';
        $template['smenu'] = 'View Service Requests';
        $template['pTitle'] = "View Service Requests";
        $template['pDescription'] = "View and Manage Service Requests";
        $template['page_head'] = "Service Request Management";
        $template['datatable'] = 1;
        //$template['Service_request_data'] = $this->Service_request_model->getService_requestData();

		$this->load->view('template',$template);
	}

	public function getService_requestData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['Service_request_id'])||empty($_POST['Service_request_id']) || 
		   !is_numeric($Service_request_id = $_POST['Service_request_id'])){
			echo json_encode($resArr);exit;
		}
		 $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
		$mechData = $this->Service_request_model->getService_requestData($Service_request_id,$view_all);
      //echo json_encode($mechData);exit;
		if(empty($mechData)){
			echo json_encode($resArr);exit;
		}

		$resArr['status'] = 1;
		$resArr['data'] = $mechData;
		echo json_encode($resArr);exit;
	}

	function changeStatus($Service_request_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Service_request_id) || !is_numeric($Service_request_id = decode_param($Service_request_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Service_request'));
		}
		$status = $this->Service_request_model->changeStatus($Service_request_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Service_request'));
	}

	
	

	


public function check_email_availability() {
   			
		$email=$this->input->post('email');

        $result = $this->Service_request_model->email_availability_check($email);
		echo json_encode($result);
		
		
	}


public function get_all_Service_request() {
	$data = $_GET;
//print_r($data);exit;
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];

	 $columns = array("garage_request.id","sub_services.sub_services","services.service_name","garage_request.booking_date");
	
	
	$value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
        }



	$prod_list = $this->Service_request_model->get_all_Service_request($value);

	//print_r($prod_list);exit;
   
    $all_list = $this->Service_request_model->get_all_Service_request();

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Service_request_model->get_all_Service_request($value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {
$vehicle_dtl = "Model:".$r->model."<br>
                Make:".$r->make."<br>
                Year:".$r->year."<br>";  

$action = " <a class='btn btn-sm btn-info' onclick='viewRequestDetails(".$r->id.",".$r->cust_id.")'>
                       <i class='fa fa-cog'></i> VIEW
                                </a>";

// $action .= "  <a class='btn btn-info btn-sm' href='".base_url()."Service_request/editService_requests/".encode_param($r->cust_id)."'>
//                                              <i class='fa fa-pencil'></i>Edit
//                                          </a>";
                                  
                                      
                                               
// $action .=   "  <a class='btn btn-sm btn-danger' href='".base_url()."Service_request/changeStatus/".encode_param($r->cust_id).'/2' ."'
//                             onClick='return doconfirm()'>
//                           <i class='fa fa-fw fa-trash'></i>Delete
//                         </a>";   
                         
                       
                                        
if($r->status == 1){ 
$status =   "<button type='button' class='btn btn-primary'>Requested</button>";
                                         } else if ($r->status == 2) {
                                          
$status =  "<button type='button' class='btn btn-info'>Assigned</button>";
                        } else if ($r->status == 3) {
   $status =  "<button type='button' class='btn btn-warning'>Respond</button>";
                         } else if ($r->status == 4) {

$status =  "<button type='button' class='btn'>Quote Send</button>";
                        } else if ($r->status == 5) {
$status =  "<button type='button' class='btn btn-success'>Approved</button>";

                   }else if ($r->status == 0) {
$status =  "<button type='button' class='btn btn-danger'>Cancelled</button>";

                   }



$assign_dtl = "<a class='btn btn-info btn-sm' href='".base_url()."Service_request/service_assign/".encode_param($r->id)."'>
                                             <i class='fa fa-pencil'></i>Assign
                                         </a>";
  $assign_dt2 = '';                                       
//if (($r->status == 3) && ($r->status == 4)) {
$assign_dt2.= "<a class='btn btn-info btn-sm' href='".base_url()."Garage_response/responce/".encode_param($r->id)."'>
                                             <i class='fa fa-pencil'></i>Responses
                                         </a>";
//}
                array_push($data, array(
                    $r->cust_id,
                    $r->request_code,
                    $r->customer_name.'<br>'.'<b>'.'Phone:'.'</b>'.($r->phone_no),
                    
                    $vehicle_dtl,
                    $r->service_name,
                    $r->booking_date,
                    $status,
                    $action.' '.$assign_dtl .' '. $assign_dt2
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}

public function service_assign($request_id=''){
       //print_r(decode_param($request_id));exit;
		    $template['page'] = 'Service_request/assign';
        $template['menu'] = 'Service Assign Management';
        $template['smenu'] = 'View Service Assign';
        $template['pTitle'] = "View Service Assign";
        $template['pDescription'] = "View and Manage Service Assign";
        $template['page_head'] = "Service Assign Management";
        $template['datatable'] = 1;
        $template['request_id'] = $request_id;
        $template['requestData'] = $this->Service_request_model->getService_requestData(decode_param($request_id));
       
        $template['garageData'] = $this->Service_request_model->getGarageData();
        $template['assign_garage'] = $this->Service_request_model->getAssignGarage(decode_param($request_id));
  //echo json_encode($template['assign_garage']);exit;
		$this->load->view('template',$template);
	}

	

public function assign_garage(){
   
    if(!isset($_POST)||empty($_POST)||!isset($_POST['garage'])||empty($_POST['garage'])){
      $resArr = array('status'=>0);
      echo json_encode($resArr);exit;

    }
    $garages = $_POST['garage'];
    $req_id = $_POST['req_id'];
    
    $mechData = $this->Service_request_model->Garage_assign($garages,$req_id);
      
    if(!empty($mechData)){
      $resArr = array('status'=>1);
      echo json_encode($resArr);exit;
    }

    $resArr['status'] = 0;
    $resArr['data'] = $mechData;
    echo json_encode($resArr);exit;
  }


public function getServiceData(){
   $resArr = array('status'=>0);
   if(!isset($_POST)||empty($_POST)||!isset($_POST['request_id'])||empty($_POST['request_id']) || 
      !is_numeric($request_id = $_POST['request_id'])){
     echo json_encode($resArr);exit;
   }
  
   $mechData = $this->Service_request_model->getGarage_ServiceData($request_id);
    
   if(empty($mechData)){
     echo json_encode($resArr);exit;
   }

   $resArr['status'] = 1;
   $resArr['data'] = $mechData;
   echo json_encode($resArr);exit;
  }



}
?>