<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class   Vehicle_details extends CI_Controller {
 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Vehicle_model');
    }


    public function index()
    {


     $data['menu'] = 'Vehicle Management';
     $data['smenu'] = 'View Vehicle List';
     $data['pTitle'] = "Vehicle Management";
     $data['pDescription'] = "View Vehicle List";
     $data['page'] = 'vehicle_details/list';
     $data['datatable'] = 1;
     $data['vehicleData']=$this->Vehicle_model->getvehicleData();
     $this->load->view('template', $data);
    }



	public function create($user_id)
	{
       
   $data['menu'] = 'Vehicle Management';
   $data['smenu'] = 'Add Vehicle';
   $data['pTitle'] = "Vehicle Management";
   $data['pDescription'] = "Add Vehicle";
   $data['user_id'] =decode_param($user_id);
   $data['page'] = 'vehicle_details/create';
   $this->load->view('template',$data);
	}

public function create_vehicle()
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Vehicle_details/create'));
    }



    $err = 0;
    $errMsg = '';
    if($err == 0 && (!isset($_POST['user_id']) || empty($_POST['user_id']))){
        $err = 1;
        $errMsg = 'Customer details are missing!';
        
    } else if($err == 0 && (!isset($_FILES) || empty($_FILES) || 
        !isset($_FILES['vehicle_pic']) || empty($_FILES['vehicle_pic']))){
        $err = 1;
        $errMsg = 'Provide a vehicle image';
    }if($err == 0 && (!isset($_POST['model']) || empty($_POST['model']))){
        $err = 1;
        $errMsg = 'Provide a model!';
        
    }if($err == 0 && (!isset($_POST['year']) || empty($_POST['year']))){
        $err = 1;
        $errMsg = 'Provide a year!';
        
    }


 
    if($err == 0){


        $files = $_FILES;
        $cpt = count($_FILES['vehicle_pic']['name']);

        $_FILES['userfile']['name']= time().$files['vehicle_pic']['name'];
        $_FILES['userfile']['type']= $files['vehicle_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['vehicle_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['vehicle_pic']['error'];
        $_FILES['userfile']['size']= $files['vehicle_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/vehicle';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        
        $uploading_file = $this->upload->data();
        $image = $uploading_file['file_name'];
        $new_array = array('width'=>100, 'height'=>100);
           

         $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
        
  
       
        $vehicleData = array(
            'cust_id' => $this->input->post('user_id'),
            'vehicle_name' => $this->input->post('vehicle_name'),
            'model' => $this->input->post('model'),
            'year' => $this->input->post('year'),
            'make' => $this->input->post('make'),
            'vin' => $this->input->post('vin'),
            'mileage' => $this->input->post('mileage'),
            'vehicle_image' => $image_file
        );
       
    }

    if($err == 1){
        $flashMsg['message'] = $errMsg;
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Vehicle_details/create'));
    }



    $qry = $this->Vehicle_model->add_vehicle($vehicleData);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully added.",'class' => 'success'));
       redirect(base_url().'Customer');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }

 



 
}


function edit($vehicle_id=''){

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(empty($vehicle_id) || empty(decode_param($vehicle_id))){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Vehicle_details/list'));
    }
    
    $data['menu'] = 'Vehicle Management';
    $data['smenu'] = 'Edit Vehicle';
    $data['pTitle'] = "Edit Vehicle";
    $data['pDescription'] = "Update Vehicle Data";
    $data['page'] = 'vehicle_details/create';
    $data['vehicle_id'] = $vehicle_id;
    $data['vehicleData'] = $this->Vehicle_model->getvehicleData(decode_param($vehicle_id));
//echo json_encode($data['vehicleData']);exit;
    $this->load->view('template',$data);
}


public function edit_vehicle($vehicle_id='')
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');

    if(!isset($_POST) || empty($_POST) || empty($vehicle_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Vehicle_details'));
    }

    if(isset($_FILES['vehicle_pic']['name']) && !empty($_FILES['vehicle_pic']['name']))
    {

        $files = $_FILES;
        $cpt = count($_FILES['vehicle_pic']['name']);

        $_FILES['userfile']['name']= time().$files['vehicle_pic']['name'];
        $_FILES['userfile']['type']= $files['vehicle_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['vehicle_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['vehicle_pic']['error'];
        $_FILES['userfile']['size']= $files['vehicle_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/service';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        if(!$upload_img){

            $this->session->set_flashdata('message', array('message' => $this->upload->display_errors(),'class' => 'danger'));
            
        } else{
            $uploading_file = $this->upload->data();
            $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
           
        }
        
        $VehicleData = array(
            'cust_id' => $this->input->post('user_id'),
            'vehicle_name' => $this->input->post('vehicle_name'),
            'model' => $this->input->post('model'),
            'year' => $this->input->post('year'),
            'make' => $this->input->post('make'),
            'mileage' => $this->input->post('mileage'),
            'vehicle_image' => $image_file);

        
        
    }else{
        $VehicleData = array(
             'cust_id' => $this->input->post('user_id'),
            'vehicle_name' => $this->input->post('vehicle_name'),
            'model' => $this->input->post('model'),
            'year' => $this->input->post('year'),
            'make' => $this->input->post('make'),
            'mileage' => $this->input->post('mileage'));
            
    }

    
    $result = $this->Vehicle_model->update_Vehicle(decode_param($vehicle_id),$VehicleData);
    if($result)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully Updated.",'class' => 'success'));
       redirect(base_url().'customer');
       
       
   }else{
    $this->session->set_flashdata('message', array('message' => "Please try again.",'class' => 'danger'));
    
}



}


function changeStatus($service_id = '',$status ='1'){
        
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
        if(empty($service_id) || !is_numeric($service_id = decode_param($service_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Vehicle_details'));
        }
        $status = $this->Service_model->changeStatus($service_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Vehicle_details'));
    }





}
?>