

<style>
/* The container */
.container {
  display: block;
  position: relative;
  padding-left: 35px;
  margin-bottom: 12px;
  cursor: pointer;
  font-size: 22px;
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
}

/* Hide the browser's default radio button */
.container input {
  position: absolute;
  opacity: 0;
  cursor: pointer;
}

/* Create a custom radio button */
.checkmark {
  position: absolute;
  top: 0;
  left: 0;
  height: 25px;
  width: 25px;
  background-color: #3e90a9;
  border-radius: 50%;
}

/* On mouse-over, add a grey background color */
.container:hover input ~ .checkmark {
  background-color: #ccc;
}

/* When the radio button is checked, add a blue background */
.container input:checked ~ .checkmark {
  background-color: #2196F3;
}

/* Create the indicator (the dot/circle - hidden when not checked) */
.checkmark:after {
  content: "";
  position: absolute;
  display: none;
}

/* Show the indicator (dot/circle) when checked */
.container input:checked ~ .checkmark:after {
  display: block;
}

/* Style the indicator (dot/circle) */
.container .checkmark:after {
  top: 9px;
  left: 9px;
  width: 8px;
  height: 8px;
  border-radius: 50%;
  background: white;
}
</style>

<!-- PAGE-INDEX-STARTS -->

<div class="breadcrumbs">
    <div class="breadcrumbs-inner">
        <?php
        if($this->session->flashdata('message')) {
        $message = $this->session->flashdata('message');
        ?>
            <div class="alert alert-<?php echo $message['class']; ?>">
                <button class="close" data-dismiss="alert" type="button">×</button>
                <?php echo $message['message']; ?>
            </div>
        <?php } ?>
        <div class="row m-0">
            <div class="col-sm-4">
                <div class="page-header float-left">
                    <div class="page-title">
                        <h1><?= $pTitle ?></h1>
                    </div>
                </div>
            </div>
            <div class="col-sm-8">
                <div class="page-header float-right">
                    <div class="page-title">
                        <ol class="breadcrumb text-right">
                            <li><a href="<?= base_url() ?>">Dashboard</a></li>
                            <li><a ><?= $menu ?></a></li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- PAGE-INDEX-ENDS -->

<!-- PAGE-CONTENT-STARTS -->
<?php $setting = getSettings();?>
<div class="content">
    <div class="animated fadeIn">
      <div class="row">
           <div class="col-md-12">
                <div class="card">
                  <div class="card-header">
                        <strong class="card-title">POS Details</strong>
                    </div>
                    <div class="card-body">
                      <div class="row">

                        <div class="col-md-4">  <label><b>Request Code:</b></label><?= $requestData['posReq_id'] ?></div>
                        <div class="col-md-4"><label><b>Product Name:</b></label><?= $requestData['unique_name'] ?></div>
                        <div class="col-md-4"><label><b>Customer Name:</b></label><?= $requestData['cust_name'] ?></div>
                      </div>
                      <div class="row">
                        <div class="col-md-4"> <label><b>Customer Phone:</b></label><?= $requestData['phone_no'] ?></div>
                        <div class="col-md-4"><label><b>Location:</b></label><?= $requestData['area'] ?></div>
                      </div>
                    </div>
                </div>
              </div>
      </div>

      <div class="row">
           <div class="col-md-12">
                <div class="card">
                  <div class="card-header">
                        <strong class="card-title">Vehicle Details</strong>
                    </div>
                    <div class="card-body col-md-8">
                      <div class="row">
                        <div class="col-md-4"><label><b>Make:</b></label><?= $requestData['make'] ?></div>
                        <div class="col-md-4"><label><b>Model:</b></label><?= $requestData['model'] ?></div>
                        <div class="col-md-4"><label><b>Year:</b></label><?= $requestData['year'] ?></div>
                      </div>
                      <div class="row">
 <div class="col-md-4">  <label><b>Vehicle Name:</b></label><?= $requestData['vehicle_name'] ?></div>
  <div class="col-md-4">  <label><b>Mileage:</b></label><?= $requestData['mileage'] ?></div>
                      </div>
                    </div>
                </div>
              </div>
      </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <strong class="card-title"><?= $pDescription ?></strong>
                    </div>
                    <input type="hidden" value="<?= $requestData['id'] ?>" id="req_id" class="req_id">  
                    <div class="card-body">
                        <table id="" class="table table-striped table-bordered " style='border-bottom-width: 2px;' >
                            <?php if(isset($pos_list) && !empty($pos_list)) { ?>
                            <thead>
                                <tr><th>Quote Code</th>
                                    <th>Pos Code</th>                                    
                                    <th>Pos Name</th>
                                    <th>Phone Number</th>
                                    <th>Cost</th>
                                    <th>Margin</th>
                                    <th>VAT</th>
                                    <th>Total</th>
                                    <th>Edit</th>
                                    <th>Select</th>
                                </tr>
                            </thead>
                             <?php foreach ($pos_list  as $key => $value) { ?>
                            <tbody>
                              <tr> 
                                  <td><?= $value['pos_resp_code'] ?></td>
                                  <td><?= $value['pos_code'] ?></td>
                                  <td><?= $value['name'] ?></td>
                                  <td><?= $value['phone_no'] ?></td>
                                  <td><?= $value['cost'] ?></td>
                                  <td><?php echo (isset($value['margin']) && !empty($value['margin']))? $value['margin']: '--' ?></td>
                                  <td><?= $setting['VAT'] ?></td>
                                  <td><?= $value['total'] ?></td>
                                  <td>
                                    <?php
                                      $class = ($value['status'] == 1)?'':'isDisabled';
                                    ?>
                                    <a class="btn btn-info btn-sm view_wish <?php echo $class ?>" onclick='changeMargins("<?= $request_id ?>","<?= $value['pos_resp_code'] ?>")'><i class='fa fa-pencil'></i>Edit</a></td>
                                  <td>
                                    <?php if ($value['status'] == '1') { ?>
                                        <label class="container"><input type="checkbox" value="<?= $value['ps_rsp_id'] ?>">
                                      <span class="checkmark"></span></label>
                                    <?php } if ($value['status'] == '2') { ?>
                                    <button type='button' class='btn btn-warning'>Quote Send</button>

                                    <?php } ?>
                                  </td>
                             </tr>

                            </tbody>
                          <?php  } } ?>  
                          <td colspan="10">
                           <button type="button" class="btn btn-primary" id="send_quote" data-dismiss="modal" style="float: right;">Send Quote</button>
                                </a>
                              </td>     
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- PAGE-CONTENT-ENDS -->
        
 
<!-- PAGE-CONTENT-ENDS -->
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>     
<script type="text/javascript">
  

  $("#send_quote").on('click', function(){
    var selectedValues = [];
    $("input[type=checkbox]:checked").each ( function() {
        selectedValues.push($(this).val());     
    });
    var req_id = jQuery('[id="req_id"]').val();
    if(selectedValues == '' || req_id == ''){
      return false;
    }
    var post_data = {"selectedIds": selectedValues,"req_id":req_id};
    $.ajax({
      type: "POST",
      url: '<?php echo base_url('Pos_response/approve_quote'); ?>',
      data: post_data,
      success: function(response){
        window.location.reload();
      }
    });   
  })


function changeMargins(reqCode,respCode){
  if(reqCode == '' || reqCode==undefined || reqCode == 'undefined' || reqCode == null || reqCode=='null' || respCode == '' || respCode==undefined || respCode == 'undefined' || respCode == null || respCode=='null'){
    return true;
  }
  modalTrigger('Product Details','');
  addModalLoader();
  jQuery.ajax({
    url : base_url+"Pos_response/editMargins",
    type : 'POST',
    data : {'requestId':reqCode,'respCode':respCode,'view_all':'1'},
    success : function(resp){
      console.log(resp);
      if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
        remModalLoader();
        jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
        return false;
      }

      var resp_data = jQuery.parseJSON(resp);
      if(resp_data['status'] == 'error'){
        remModalLoader();
        jQuery('[id="modal_content"]').htnl('Something went wrong, Please try again later...!');
        return false;
      }

      var margin = (resp_data['posDetails'].margin == 'undefined' || resp_data['posDetails'].margin == undefined || resp_data['posDetails'].margin == null || resp_data['posDetails'].margin == 'null' || resp_data['posDetails'].margin == '')?'--':resp_data['posDetails'].margin;

      var issueHtml = '';
      issueHtml +=  '<form id="customQuote" role="form" method="post">'+
                       '<div class="col-md-12" style="padding-top:10px">'+
                        '<div class="row"><label><b>Product Details</b></label></div>'+
                        '<div class="row">'+
                            '<div class="col-md-6">'+
                                '<div class="row">'+
                                    '<div class="col-md-6">Request Code</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].posReq_id+'</label></div>'+
                                '</div> '+
                                '<div class="row">'+
                                    '<div class="col-md-6">Customer Name</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].cust_name+'</label></div>'+
                                '</div> '+
                                '<div class="row">'+
                                    '<div class="col-md-6">Product Name</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].unique_name+'</label></div>'+
                                '</div> '+
                                '<div class="row">'+
                                    '<div class="col-md-6">Response Code</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['posDetails'].pos_resp_code+'</label></div>'+
                                '</div> '+
                                '<div class="row">'+
                                    '<div class="col-md-6">Product Cost</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['posDetails'].cost+'</label></div>'+
                                '</div> '+
                                '<div class="row">'+
                                    '<div class="col-md-6">Product Total</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['posDetails'].total+'</label></div>'+
                                '</div> '+
                            '</div>'+
                            '<div class="col-md-6">'+
                                '<div class="row"> '+
                                    '<div class="col-md-6">Pos Name</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['posDetails'].name+'</label></div>'+
                                '</div> '+
                                '<div class="row"> '+
                                    '<div class="col-md-6">Customer Ph No</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].phone_no+'</label></div> '+
                                '</div> '+
                                '<div class="row"> '+
                                    '<div class="col-md-6">Customer Location</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].area+'</label></div> '+
                                '</div> '+
                                '<div class="row"> '+
                                    '<div class="col-md-6">Pos Phone Number</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].phone_no+'</label></div> '+
                                '</div> '+
                                '<div class="row">'+
                                    '<div class="col-md-6">Product Margin</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+margin+'</label></div>'+
                                '</div> '+
                            '</div>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-md-12" style="padding-top:20px;">'+
                            '<div class="row"><label><b>Vehicle Details</b></label></div>'+
                            '<div class="row">'+
                            '<div class="col-md-6">'+
                                '<div class="row">'+
                                    '<div class="col-md-6">Vehicle Make</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].make+'</label></div>'+
                                '</div> '+
                                 '<div class="row">'+
                                    '<div class="col-md-6">Vehicle Model</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].model+'</label></div>'+
                                '</div> '+
                            '</div>'+
                             '<div class="col-md-6">'+
                                 '<div class="row">'+
                                    '<div class="col-md-6">Vehicle Year</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].year+'</label></div>'+
                                '</div> '+
                                 '<div class="row">'+
                                    '<div class="col-md-6">Vehicle mileage</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-4"><label>'+resp_data['reqDetails'].mileage+'</label></div>'+
                                '</div> '+
                            '</div>'+
                            '</div>'+
                        '</div> '+
                        '<div class="col-md-12">'+
                           '<div class="row"><label><b>Add Margin</b></label></div>'+
                           '<div class="col-md-12">'+
                               '<div class="row">'+
                                    '<div class="col-md-3"> Margin</div>'+
                                    '<div class="col-md-1">:</div>'+
                                    '<div class="col-md-5">'+
                                        '<input class="marginTop10" placeholder="Margin" id="margin" type="number" name="margin">'+
                                        '<input class="marginTop10" id="respCode" value="'+resp_data['posDetails'].ps_rsp_id+'" type="hidden">'+
                                        '<input class="marginTop10" id="cost" value="'+resp_data['posDetails'].cost+'" type="hidden">'+
                                    '</div>'+
                                    '<div class="col-md-3">'+
                                        '<button type="button" style="height: 25px;font-size: 13px;padding-bottom: 22px;" onclick="submitCustQuote(event);" class="btn btn-primary">Submit</button>'+
                                    '</div>'+
                                '</div>'+
                            '</div>'+
                        '</div>'+
                    '</form>';
      remModalLoader();
      jQuery('[id="modal_content"]').html(issueHtml);
    },
    fail: function(xhr, textStatus, errorThrown){
        remModalLoader();
        jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
    },
    error: function (ajaxContext) {
        remModalLoader();
        jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
    }
  })
}

function submitCustQuote(e){
  e.preventDefault();

  var margin = jQuery('[id="margin"]').val();
  var respCode = jQuery('[id="respCode"]').val();
  var cost = jQuery('[id="cost"]').val();

  if((margin != '' && respCode == '') || (margin == '' && respCode != '')){
    if(margin == ''){
      jQuery('[id="margin"]').addClass('errInput');
    }
    if(respCode == '' || cost == ''){
      remModalLoader();
      jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
    }
    return false;
  }
  var subTotal = parseInt(cost) + parseInt(margin);

  jQuery.ajax({
      url  : base_url+"Pos_response/insertCustomMargin", 
      type : 'POST',
      data : {"margin":margin,"respId":respCode,'total':subTotal},
      success: function(resp){
        if(resp == '' || resp == undefined || resp == 'undefined' || resp == null || resp == 'null'){
          remModalLoader();
          jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
          return false;
        }
        var resp_data = jQuery.parseJSON(resp);
        if(resp_data['status'] == 'error'){
          remModalLoader();
          jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
          return false;
        }
        else{
          window.location.reload();
        }
      },
        fail: function(xhr, textStatus, errorThrown){
          remModalLoader();
          jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
        },
        error: function (ajaxContext) {
          remModalLoader();
          jQuery('[id="modal_content"]').html('Something went wrong, please try again later...!');
      }
  })
}

    

    </script>

</script

