<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Garage_profile extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Garage_profile_model');
		 if(!$this->session->userdata('logged_garage')) {
            redirect(base_url());
        }

 	}
	
	

	public function viewProfile() {
      $id = $this->session->userdata('garage_id');

		$template['page'] = 'Profile/viewProfile';
        $template['menu'] = "Profile";
        $template['smenu'] = "Edit Profile";
        $template['pTitle'] = "Edit Profile";
        $template['pDescription'] = "Edit User Profile";
        $template['admin'] = $this->Garage_profile_model->getAdminData($this->session->userdata('id'));
        $template['services'] = $this->Garage_profile_model->getGarageServices();
        $template['garageData'] = $this->Garage_profile_model->getGarageData($id);
        $template['Garage_id'] =encode_param($id);
        $template['amenities'] = $this->Garage_profile_model->getAmenities();
        $template['serviceData'] = $this->Garage_profile_model->getServiceData($id);
         //echo json_encode($template);exit;
		$this->load->view('template',$template);
	}

	



public function updateGarage($Garage_id = ''){
        $id=decode_param($Garage_id);

        $err = 0;
        $errMsg = '';
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
        if(!isset($_POST) || empty($_POST) || !isset($_FILES) || empty($_FILES)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Garage_profile/viewProfile'.$Garage_id));
        }
         
        if($err == 0 && (!isset($_POST['name']) || empty($_POST['name']))){
            $err = 1;
            $errMsg = 'Provide Garage Name';
        }else if($err == 0 && (!isset($_POST['email']) || empty($_POST['email']))){
            $err = 1;
            $errMsg = 'Provide a Garage Email';
        }else if($err == 0 && (!isset($_POST['phone']) || empty($_POST['phone']))){
            $err = 1;
            $errMsg = 'Provide Garage Phone';
    
        }
       
        if($err == 0){
           $config = set_upload_service("assets/uploads/Garage");
            $this->load->library('upload');
            $config['file_name'] = time()."_".$_FILES['profile_image']['name'];
            $this->upload->initialize($config);
            if(!$this->upload->do_upload('profile_image')){
                $err = 1;
                $errMsg = $this->upload->display_errors();
            }else{
                $upload_data = $this->upload->data();
                 $image = $upload_data['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           
                $image_file = $config['upload_path']."/".$upload_data['file_name'];
              
             $_POST['profile_image'] = $image_file;
            }
        }

        if($err == 1){
            $flashMsg['message'] = $errMsg;
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Garage_profile/viewProfile/'.$Garage_id));
        }
       
        $status = $this->Garage_profile_model->updateGarage($id,$_POST);
       
        if($status == 1){
            $flashMsg = array('message'=>'Update Successfully!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
           redirect(base_url('Garage_profile/viewProfile/'.encode_param($id)));
        } else if($status == 2){
            $flashMsg = array('message'=>'Email ID already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage_profile/viewProfile/'.$Garage_id));
        } else if($status == 3){
            $flashMsg = array('message'=>'Phone Number already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage_profile/viewProfile/'.$Garage_id));
        } else if($status == 4){
            $flashMsg = array('message'=>'User Name already exist..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage_profile/viewProfile/'.$Garage_id));
        } 
        else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('Garage_profile/viewProfile/'.$Garage_id));
        }
    }







}
?>