<?php
defined('BASEPATH') OR exit('No direct script access allowed');

Class Service extends CI_Controller {
 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Service_model');

 if(!$this->session->userdata('logged_garage')) {
            redirect(base_url());
        }


        
    }


    public function index()
    {


     $data['menu'] = 'Service Management';
     $data['smenu'] = 'View Service List';
     $data['pTitle'] = "Service Management";
     $data['pDescription'] = "View Service List";
     $data['page'] = 'service/list';
     $data['datatable'] = 1;
     $data['serviceData']=$this->Service_model->getserviceData();
     $this->load->view('template', $data);
    }



	public function create()
	{
   $data['menu'] = 'Service Management';
   $data['smenu'] = 'Add Service';
   $data['pTitle'] = "Service Management";
   $data['pDescription'] = "Add Service";
   $data['page'] = 'service/create';
   $this->load->view('template',$data);
	}

public function create_service()
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(!isset($_POST) || empty($_POST)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Service/create'));
    }



    $err = 0;
    $errMsg = '';
    if($err == 0 && (!isset($_POST['service_name']) || empty($_POST['service_name']))){
        $err = 1;
        $errMsg = 'Provide a Service Name';
        
    } else if($err == 0 && (!isset($_FILES) || empty($_FILES) || 
        !isset($_FILES['service_pic']) || empty($_FILES['service_pic']))){
        $err = 1;
        $errMsg = 'Provide a Service Image';
    }


 
    if($err == 0){



        $files = $_FILES;
        $cpt = count($_FILES['service_pic']['name']);

        $_FILES['userfile']['name']= time().$files['service_pic']['name'];
        $_FILES['userfile']['type']= $files['service_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['service_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['service_pic']['error'];
        $_FILES['userfile']['size']= $files['service_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/service';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        
        $uploading_file = $this->upload->data();
         $image = $uploading_file['file_name'];
            $new_array = array('width'=>100, 'height'=>100);
           

         $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
        

       
        $serviceData = array(
            'service_name' => $this->input->post('service_name'),
            'image' => $image_file
        );
       
    }

    if($err == 1){
        $flashMsg['message'] = $errMsg;
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Service'));
    }



    $qry = $this->Service_model->add_service($serviceData);
    if($qry)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully added.",'class' => 'success'));
       redirect(base_url().'Service');
       
       
   }else{
     $this->session->set_flashdata('message',$flashMsg);
     
 }

 



 
}


function edit($service_id=''){
    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    if(empty($service_id) || empty(decode_param($service_id))){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Service/list'));
    }
    
    $data['menu'] = 'Service Management';
    $data['smenu'] = 'Edit Service';
    $data['pTitle'] = "Edit Service";
    $data['pDescription'] = "Update Service Data";
    $data['page'] = 'Service/create';
    $data['service_id'] = $service_id;
    $data['serviceData'] = $this->Service_model->getserviceData(decode_param($service_id));
   
    $this->load->view('template',$data);
}


public function edit_service($service_id='')
{

    $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');

    if(!isset($_POST) || empty($_POST) || empty($service_id)){
        $this->session->set_flashdata('message',$flashMsg);
        redirect(base_url('Service'));
    }

    if(isset($_FILES['service_pic']['name']) && !empty($_FILES['service_pic']['name']))
    {

        $files = $_FILES;
        $cpt = count($_FILES['service_pic']['name']);

        $_FILES['userfile']['name']= time().$files['service_pic']['name'];
        $_FILES['userfile']['type']= $files['service_pic']['type'];
        $_FILES['userfile']['tmp_name']= $files['service_pic']['tmp_name'];
        $_FILES['userfile']['error']= $files['service_pic']['error'];
        $_FILES['userfile']['size']= $files['service_pic']['size'];
        $config = array();
        $config['upload_path'] = './assets/uploads/service';
        $config['allowed_types'] = 'gif|jpg|jpeg|png|flv|f4v';
        $config['max_size']      = '';
        $config['overwrite']     = FALSE;
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        $upload_img = $this->upload->do_upload();
        
        if(!$upload_img){

            $this->session->set_flashdata('message', array('message' => $this->upload->display_errors(),'class' => 'danger'));
            
        } else{
            $uploading_file = $this->upload->data();
            $image_file = $config['upload_path'].'/'.$uploading_file['file_name'];
           
        }
        
        $serviceData = array(
             'service_name' => $this->input->post('service_name'),
            'image' => $image_file);

        
        
    }else{
        $serviceData = array(
             'service_name' => $this->input->post('service_name'));
            
    }

    
    $result = $this->Service_model->update_service(decode_param($service_id),$serviceData);
    if($result)
    {
        
       $this->session->set_flashdata('message', array('message' => "Successfully Updated.",'class' => 'success'));
       redirect(base_url().'Service');
       
       
   }else{
    $this->session->set_flashdata('message', array('message' => "Please try again.",'class' => 'danger'));
    
}



}


function changeStatus($service_id = '',$status ='1'){
        
        $flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
        if(empty($service_id) || !is_numeric($service_id = decode_param($service_id))){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('Service'));
        }
        $status = $this->Service_model->changeStatus($service_id,$status);
        if(!$status){
            $this->session->set_flashdata('message',$flashMsg);
        }
        redirect(base_url('Service'));
    }





}
?>