<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Service_booking extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Service_booking_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_garage')) {
            redirect(base_url());
        }

         
    }



	public function index(){
       
		$template['page'] = 'Service_booking/list';
        $template['menu'] = 'Service Booking Management';
        $template['smenu'] = 'View Service Booking';
        $template['pTitle'] = "View Service Booking";
        $template['pDescription'] = "View and Manage Service Booking";
        $template['page_head'] = "Service Booking Management";
        $template['datatable'] = 1;
        //$template['Service_booking_data'] = $this->Service_booking_model->getService_bookingData();

		$this->load->view('template',$template);
	}

	public function getService_bookingData(){
		$resArr = array('status'=>0);
		if(!isset($_POST)||empty($_POST)||!isset($_POST['Service_booking_id'])||empty($_POST['Service_booking_id']) || 
		   !is_numeric($Service_booking_id = $_POST['Service_booking_id'])){
			echo json_encode($resArr);exit;
		}
		 $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
		$mechData = $this->Service_booking_model->getService_bookingData($Service_booking_id,$view_all);
      //echo json_encode($mechData);exit;
		if(empty($mechData)){
			echo json_encode($resArr);exit;
		}

		$resArr['status'] = 1;
		$resArr['data'] = $mechData;
		echo json_encode($resArr);exit;
	}

	function changeStatus($Service_booking_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Service_booking_id) || !is_numeric($Service_booking_id = decode_param($Service_booking_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Service_booking'));
		}
		$status = $this->Service_booking_model->changeStatus($Service_booking_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Service_booking'));
	}

	
	

	


public function check_email_availability() {
   			
		$email=$this->input->post('email');

        $result = $this->Service_booking_model->email_availability_check($email);
		echo json_encode($result);
		
		
	}


public function get_all_Service_booking() {
	$data = $_GET;
  $garage_id = $this->session->userdata('garage_id');
//print_r($data);exit;
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];

	 $columns = array("garage_booking.id","garage_booking.garage_name","garage_booking.service_name","garage_booking.booking_date");
	
	
	$value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';

	if(!empty($value['search'])) {
            $where = array();
            foreach($columns as $c) {
                $where_data[] = $c." like '%".$value['search']."%' ";
            }
            $where = implode(" OR ", $where_data);
            $where = "(".$where.")";
            $value['where'] = $where;
        }



	$prod_list = $this->Service_booking_model->get_all_Service_booking($garage_id,$value);

	//print_r($prod_list);exit;
   
    $all_list = $this->Service_booking_model->get_all_Service_booking($garage_id);

	$recordsTotal = count($all_list);

    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Service_booking_model->get_all_Service_booking($garage_id,$value);
        $filtered = count($all_list);
    }

	$data = array();
	foreach ($prod_list  as $r) {
$vehicle_dtl = "Model:".$r->model."<br>
                Make:".$r->make."<br>
                Year:".$r->year."<br>"; 
 $garage_dtl = "Name:".$r->garage_name."<br>
                Code:".$r->garage_code."<br>
                Phone:".$r->garage_phone."<br>";   

$action = "<a class='btn btn-sm btn-info' onclick='viewRequestDetails(".$r->id.",".$r->cust_id.")'>
                       <i class='fa fa-cog'></i> VIEW
                                </a>";


                         
                       
                                        
if($r->status == 1){ 
$status =   "<button type='button' class='btn btn-primary'>Booked</button>";
                                         } else if ($r->status == 2) {
                                          
$status =  "<button type='button' class='btn btn-info'>Processing</button>";
                        } else if ($r->status == 3) { 
   $status =  "<button type='button' class='btn btn-success'>Completed</button>";
                         } 
                        
$action1='';

                array_push($data, array(
                    $r->cust_id,
                    $r->booking_id,
                    $r->customer_name,
                    $r->phone_no,
                    $garage_dtl,
                    $vehicle_dtl,
                    $r->service_name,
                    $r->booking_date,
                     $status,
                    $action
                     ));
            }


	echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
  
}

public function getBookingData(){
   $resArr = array('status'=>0);
   if(!isset($_POST)||empty($_POST)||!isset($_POST['request_id'])||empty($_POST['request_id']) || 
      !is_numeric($request_id = $_POST['request_id'])){
     echo json_encode($resArr);exit;
   }
  
   $mechData = $this->Service_booking_model->Garage_BookingData($request_id);
    
   if(empty($mechData)){
     echo json_encode($resArr);exit;
   }

   $resArr['status'] = 1;
   $resArr['data'] = $mechData;
   echo json_encode($resArr);exit;
  }

	
}
?>