<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pos_request extends CI_Controller {

 public function __construct() {
        parent::__construct();
        date_default_timezone_set("Asia/Kolkata");
        $this->load->model('Pos_request_model');
         $this->load->helper('generals_helper');
        if(!$this->session->userdata('logged_pos')) {
            redirect(base_url());
        }
    }

	public function index(){
       
		$template['page'] = 'Pos_request/list';
        $template['menu'] = 'Pos Requet Management';
        $template['smenu'] = 'View Pos Requests';
        $template['pTitle'] = "View Pos Requests";
        $template['pDescription'] = "View and Manage Pos Requests";
        $template['page_head'] = "Pos Request Management";
        $template['datatable'] = 1;
        //$template['Pos_request_data'] = $this->Pos_request_model->getPos_requestData();

		$this->load->view('template',$template);
	}

	public function getPos_requestData(){
		$resArr = array('status'=>"error");
		if(!isset($_POST)||empty($_POST)||!isset($_POST['Pos_request_id'])||empty($_POST['Pos_request_id']) || 
		   !is_numeric($Pos_request_id = $_POST['Pos_request_id'])){
			echo json_encode($resArr);exit;
		}
		 $view_all = (isset($_POST['view_all']) && !empty($_POST['view_all']))?$_POST['view_all']:'';
        //$view_all = (isset($_POST['view_all']) && $_POST['view_all'] == 1)?1:0;
		$mechData = $this->Pos_request_model->getPos_requestData($Pos_request_id,$view_all);
      //echo json_encode($mechData);exit;
		if(empty($mechData)){
			echo json_encode($resArr);exit;
		}

		$resArr['status'] = 1;
		$resArr['data'] = $mechData;
		echo json_encode($resArr);exit;
	}

	function changeStatus($Pos_request_id = '',$status ='1'){
	
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
		if(empty($Pos_request_id) || !is_numeric($Pos_request_id = decode_param($Pos_request_id))){
			$this->session->set_flashdata('message',$flashMsg);
        	redirect(base_url('Pos_request'));
		}
		$status = $this->Pos_request_model->changeStatus($Pos_request_id,$status);
		if(!$status){
			$this->session->set_flashdata('message',$flashMsg);
		}
		redirect(base_url('Pos_request'));
	}

	
	

	


public function check_email_availability() {
   			
		$email=$this->input->post('email');

        $result = $this->Pos_request_model->email_availability_check($email);
		echo json_encode($result);
		
		
	}


public function get_all_Pos_request() {
	$data = $_GET;
	$pos_id = $this->session->userdata('pos_id');
	$col = $data['order'][0]['column'];
	$col_type = $data['order'][0]['dir'];
	$columns = array("pos_request.posReq_id","customer.name","customer.phone_no","pos_parts.unique_name");
	$value['order_by'] = $columns[$col];
	$value['order_type'] = $col_type;
	$value['search'] = $data['search']['value'];
	$value['start'] = $data['start'];
	$value['length'] = $data['length'];
	$value['where'] = '';
	if(!empty($value['search'])) {
        $where = array();
        foreach($columns as $c) {
            $where_data[] = $c." like '%".$value['search']."%' ";
        }
        $where = implode(" OR ", $where_data);
        $where = "(".$where.")";
        $value['where'] = $where;
    }
	$prod_list = $this->Pos_request_model->get_all_Pos_request($pos_id,$value);
    $all_list = $this->Pos_request_model->get_all_Pos_request($pos_id,'');
	$recordsTotal = count($all_list);
    $filtered = count($all_list);
    if($value['where']!='') {
        $value['length'] = '-1';
        $all_list = $this->Pos_request_model->get_all_Pos_request($pos_id,$value);
        $filtered = count($all_list);
    }
	$data = array();
	foreach ($prod_list  as $r) {
		$action = $status = '';
		$action .= "<a class='btn btn-info btn-sm view_wish' onclick='getPos_requestDetails(".$r->id.")'><i class='fa fa-fw fa-eye'></i>View</a>";
 
		if($r->status == 2){ 
			$action .= " <a class='btn btn-sm btn-success' onclick='sendQuote(".$r->id.",".$r->part_ids.")'><i class='fa fa-cog'></i> Quote</a>";
			$status =   "<button type='button' class='btn btn-primary'>New Request</button>";
		} else if ($r->status == 3) {
			$status =  "<button type='button' class='btn btn-success'>Accepted</button>";
		} else if ($r->status == 4) {
			$status =  "<button type='button' class='btn btn-info'>Quote Send to User</button>";
		} else if ($r->status == 0) {
			$status =  "<button type='button' class='btn btn-danger'>Cancelled</button>";
    	} else if ($r->status == 5) {
			$status =  "<button type='button' class='btn btn-secondary'>Quote Send to Admin</button>";
    	}
      	if($r->status == 5 || $r->status == 4){
      		$action .= " <a class='btn btn-sm btn-success' onclick='quoteDetails(".$r->id.")'><i class='fa fa-cog'></i> Quote Details</a>";
      	}
        array_push($data, array(
            $r->id,
            $r->posReq_id,
            $r->customer_name,
            $r->customer_phone,
            $r->unique_name,
            $status,
            $action
             ));
        }
		echo json_encode(array('recordsFiltered' => $filtered, 'recordsTotal' => $recordsTotal, 'data' => $data));
    }

	public function getPosData($request_id = ''){
	   	$resArr = array('status'=>"error");
	   	if(!isset($_POST)||empty($_POST)||!isset($_POST['request_id'])||empty($_POST['request_id']) || 
	      !is_numeric($request_id = $_POST['request_id'])){
	     	echo json_encode($resArr);exit;
	   	}
	  
	   	$posData = $this->Pos_request_model->getPosData($request_id);
	    
	   	if(empty($posData)){
	     	echo json_encode($resArr);exit;
	   	}
	   	$resArr['status'] = 1;
	   	$resArr['data'] = $posData;
	   	echo json_encode($resArr);exit;
	}  

	public function getPosDetails(){
		$resArr = array('status'=>"error");
	   	if(!isset($_POST)||empty($_POST)||!isset($_POST['requestId'])||empty($_POST['requestId'])){
	     	echo json_encode($resArr);exit;
	   	}
	  
	   	$posData = $this->Pos_request_model->getPosData($_POST['requestId']);
	    
	   	if(empty($posData)){
	     	echo json_encode($resArr);exit;
	   	}
	   	$resArr['status'] = 1;
	   	$resArr['data'] = $posData;
	   	echo json_encode($resArr);exit;
	}

	public function getSendQuoteDetails(){
		$resArr = array('status'=>"error");
	   	if(!isset($_POST)||empty($_POST)||!isset($_POST['requestId'])||empty($_POST['requestId'])){
	     	echo json_encode($resArr);exit;
	   	}
	  
	   	$quoteDetails = $this->Pos_request_model->getSendQuoteDetails($_POST['requestId']);
	    
	   	if(empty($quoteDetails)){
	     	echo json_encode($resArr);exit;
	   	}
	   	$resArr['status'] = 1;
	   	$resArr['data'] = $quoteDetails;
	   	echo json_encode($resArr);exit;	
	}


	
}
?>