<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class User extends CI_Controller {

	public function __construct() {
		parent::__construct();
		date_default_timezone_set("Asia/Kolkata");
        $this->load->model('User_model');
		if(!$this->session->userdata('logged_pos')) {
			redirect(base_url('Login'));
		}
 	}
	
	

	public function viewProfile() {
      
		$template['page'] = 'Profile/viewProfile';
        $template['menu'] = "Profile";
        $template['smenu'] = "Edit Profile";
        $template['pTitle'] = "Edit Profile";
        $template['pDescription'] = "Edit User Profile";
        $template['admin'] = $this->User_model->getAdminData($this->session->userdata['logged_pos']['id']);
       // pr($template['admin']);
         //echo json_encode($template);exit;
		$this->load->view('template',$template);
	}

	public function updateUser(){

 		$user_id = $this->session->userdata['logged_pos']['id'];
 		
		$flashMsg = array('message'=>'Something went wrong, please try again..!','class'=>'danger');
    	if(empty($user_id)){
            $this->session->set_flashdata('message',$flashMsg);
            redirect(base_url('User/viewProfile'));
    	}

        if(isset($_FILES['profile_image']) && !empty($_FILES['profile_image'])){
            $config = set_upload_service("uploads/profile");
            $this->load->library('upload');

            $new_name = time()."_".$_FILES['profile_image']['name'];
            $config['file_name'] = $new_name;

            $this->upload->initialize($config);

            if($this->upload->do_upload('profile_image')){
                $upload_data = $this->upload->data();
                $_POST['profile_image'] = $config['upload_path']."/".$upload_data['file_name'];
            }
        }

        if((isset($_POST['password']) || isset($_POST['cPassword'])) && (!empty($_POST['password']) || !empty($_POST['cPassword']))){
            if($_POST['password'] != $_POST['cPassword']){
                $flashMsg = array('message'=>'Re-enter Password..!','class'=>'danger');
                $this->session->set_flashdata('message', $flashMsg);
                redirect(base_url('User/viewProfile'));
            }
            $password = $_POST['password'];
            unset($_POST['password']);
            unset($_POST['cPassword']);
            $_POST['password'] = md5($password);
        } else {
            unset($_POST['password']);
            unset($_POST['cPassword']);
        }
        if (!isset($_POST['username']) || empty($_POST['username'])){
            $flashMsg = array('message'=>'Provide a valid Username..!','class'=>'danger');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('User/viewProfile')); 
        }
        $status = $this->User_model->updateUser($user_id,$_POST);
        if($status == 1){
            $flashMsg =array('message'=>'Successfully Updated User Details..!','class'=>'success');
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('User/viewProfile'));
      
        } else {
            $this->session->set_flashdata('message', $flashMsg);
            redirect(base_url('User/viewProfile'));
        }
	}
}
?>