<?php class Pos_booking_model extends CI_Model {
	public function _consruct(){
		parent::_construct();
 	}

 	function get_all_Pos_booking($filter=null) {
    	if($filter){
    		$this->db->order_by($filter['order_by'], $filter['order_type']);
    		if(!empty($filter['where'])){
    			$this->db->where($filter['where']);
    		}
    		if($filter['length']!=-1)
    			$this->db->limit($filter['length'],$filter['start']);
    	}
        $this->db->order_by('pos_booking.id','desc');
        $this->db->select("pos_booking.*,customer.name as customer_name,customer.phone_no as customer_phone,pos_parts.unique_name,pos.name as pos_name,pos.phone_no as pos_phone,customer_address.name,customer_address.phone_no,customer_address.house_no,customer_address.area,customer_address.country,customer_address.district,customer_address.city,pos_response.req_id");
        $this->db->from('pos_booking');
        $this->db->join('pos','pos.pos_id = pos_booking.pos_id');
        $this->db->join('customer', 'customer.cust_id = pos_booking.cust_id');
        $this->db->join('customer_address', 'customer_address.ID = pos_booking.address');
        $this->db->join('pos_response', 'pos_response.id = pos_booking.resp_id');
        $this->db->join("pos_parts","pos_parts.id=pos_response.pos_parts");
        $this->db->where("pos_booking.pos_id",$this->session->userdata('pos_id'));
        $this->db->group_by('pos_booking.id');
    	$res = $this->db->get();
    	return $res->result();
    }

    public function getbookdetails($bookingId){
        $this->db->select("pos_booking.*,customer_address.name,customer_address.phone_no,customer_address.house_no,customer_address.area,customer_address.country,customer_address.district,customer_address.city,customer.name as customer_name,customer.phone_no as customer_phone,pos_parts.unique_name,vehicle_model.make,vehicle_model.model,vehicle_model.year,vehicle_model.vehicle_name,vehicle_model.mileage,vehicle_model.vehicle_image,pos_request.posReq_id");
        $this->db->from('pos_booking');
        $this->db->join('pos_response', 'pos_response.id = pos_booking.resp_id');
        $this->db->join("pos_parts","pos_parts.id=pos_response.pos_parts");
        $this->db->join("pos_request","pos_request.id=pos_response.req_id");
        $this->db->join('customer', 'customer.cust_id = pos_booking.cust_id');
        $this->db->join('customer_address', 'customer_address.id = pos_booking.address');
        $this->db->join('vehicle_model', 'vehicle_model.id = pos_request.vehicle_id');
        $this->db->where('pos_booking.id',$bookingId);
        $res = $this->db->get();    
        return $res->row();
    }

    public function changeOrderStatus($postData = array()){
        if($this->db->update('pos_booking',array('est_delivery'=>$postData['expected_date'],'status'=>$postData['status']),array('id'=>$postData['bookingId']))){
            return true;
        }
    }

    public function getExpressDetails($bookingId =''){
        $this->db->select("pos_booking.*,pos_parts.unique_name,vehicle_model.make,vehicle_model.model,vehicle_model.year,vehicle_model.vehicle_name,vehicle_model.mileage,vehicle_model.vehicle_image,pos_request.posReq_id,express.name,express.express_code,express.phone_no,express.email_id");
        $this->db->from('pos_booking');
        $this->db->join('pos_response', 'pos_response.id = pos_booking.resp_id');
        $this->db->join("pos_parts","pos_parts.id=pos_response.pos_parts");
        $this->db->join("pos_request","pos_request.id=pos_response.req_id");
        $this->db->join("express","express.carrier_id=pos_booking.carrier_id");
        $this->db->join('vehicle_model', 'vehicle_model.id = pos_request.vehicle_id');
        $this->db->where('pos_booking.id',$bookingId);
        $res = $this->db->get();    
        return $res->row();
    }

}
?>