import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { HttpClientModule } from '@angular/common/http';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';


/* CUSTOM-MODULES */

import {CheckerModule} from './checker/checker.module';
import {ForexModule} from './forex/forex.module';
import {DeliveryModule} from './delivery/delivery.module';
import {StartModule} from './start/start.module';


/* Custom Services */

import { AuthService } from './providers/auth.service';
import { AuthGuard } from './providers/auth.guard';
import { WebService } from './providers/web.service';






@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    CheckerModule,
    ForexModule,
    DeliveryModule,
    ReactiveFormsModule,
    FormsModule,
    HttpClientModule,
    StartModule
  ],
  providers: [AuthGuard, AuthService, WebService],
  bootstrap: [AppComponent]
})
export class AppModule { }
