import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { WebService } from './../../providers/web.service';
import { ValidationService } from './../../providers/validation.service';
import { FormControl, FormGroup, FormBuilder, Validators, ValidationErrors } from '@angular/forms';

@Component({
  selector: 'app-addprovider',
  templateUrl: './addprovider.component.html',
  styleUrls: ['./addprovider.component.scss']
})
export class AddproviderComponent implements OnInit {
  providerForm: FormGroup;
  mobnumPattern = '^((\\+?)|0)?[0-9]{0,20}$';
  emailPattern = '^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$';
  providerSubmit: boolean;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    public vs: ValidationService,
    public service: WebService,
    private formBuilder: FormBuilder
    ) {
      this.providerSubmit = false;
    }

  ngOnInit() {
    this.providerForm = this.formBuilder.group({
      'name':  ['', Validators.compose([Validators.required])],
    });
  }

  goToPage(path, data = null){
    console.log(data);
    this.router.navigateByUrl(path,{queryParams:data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

}
