// COMMON-ANGULAR-MODULES

import { ModuleWithProviders } from '@angular/core'

// ROUTING

import { Routes, RouterModule } from '@angular/router';

//IMPORTED-PAGE-COMPONENTS

import { IndexComponent } from './index/index.component';
import { AddproviderComponent} from './addprovider/addprovider.component';
import { EditproviderComponent } from './editprovider/editprovider.component';
import { ManageproviderComponent } from './manageprovider/manageprovider.component';
import { ForexproviderComponent } from './forexprovider/forexprovider.component';
import { HomeComponent } from './home/home.component';
import { CurrencyComponent } from './currency/currency.component';
import { ChangepinComponent } from './changepin/changepin.component';
import { AuthGuard } from './../providers/auth.guard';


const ModuleRoutes: Routes = [

	{ path: 'checker', component: IndexComponent, canActivate: [AuthGuard],
		children: [
			{ path: 'addprovider', component: AddproviderComponent },
			{ path: 'editprovider', component: EditproviderComponent },
			{ path: 'delivery', component: ManageproviderComponent },
			{ path: 'forex', component: ForexproviderComponent },
			{ path: 'home', component: HomeComponent },
			{ path: 'currency', component: CurrencyComponent },
			{ path: 'changepin', component: ChangepinComponent }
		]
	}
];

export const moduleRouting: ModuleWithProviders = RouterModule.forChild(ModuleRoutes)

