import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { WebService } from './../../providers/web.service';
import { ValidationService } from './../../providers/validation.service';

@Component({
  selector: 'app-manageprovider',
  templateUrl: './manageprovider.component.html',
  styleUrls: ['./manageprovider.component.scss']
})
export class ManageproviderComponent implements OnInit {
  providerList: any[];
  fname: any;
  lang =  'ar';
  responseMsg: any;

  constructor(private router: Router, private route: ActivatedRoute, public vs: ValidationService, public service: WebService) {
    this.responseMsg = '';
  }

  ngOnInit() {
    this.getProvider();
  }

  getProvider() {
    this.fname = 'providers';
    const post_data = {'type': 3};
      this.service.post_data(this.fname, post_data).subscribe(response => {
        console.log(response);
        if (response.code === 1) {
          this.providerList = response.responseResult;
        } else {
          this.responseMsg = '<small style="color:red;">' + this.vs.errorCode[this.lang][response.errorCode] + '</smal>';
        }
      }, (error) => {
        this.responseMsg = '<small style="color:red;">' + this.vs.errorCode[this.lang]['ER08'] + '</smal>';
    });

    const This = this;
    setTimeout(function() {
      This.responseMsg = '';
    }, 3000);
  }

  goToPage(path, data = null) {
    console.log(data);
    this.router.navigateByUrl(path, {queryParams: data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  deleteClick(provider_id: any) {
    const res = confirm('Do you want to remove this user ?');
    if (res === true) {
      this.fname = 'provider_delete';
      const post_data = {'provider_id': provider_id};
        this.service.post_data(this.fname, post_data).subscribe(response => {
          console.log(response);
          if (response.code === 1) {
            this.getProvider();
            this.responseMsg = '<small style="color:green;">' + this.vs.errorCode[this.lang]['ER08'] + '</smal>';
          } else {
            this.responseMsg = '<small style="color:red;">' + this.vs.errorCode[this.lang][response.errorCode] + '</smal>';
          }
        }, (error) => {
          this.responseMsg = '<small style="color:red;">' + this.vs.errorCode[this.lang]['ER08'] + '</smal>';
      });
    }
    const This = this;
    setTimeout(function() {
      This.responseMsg = '';
    }, 3000);
  }

  changePinClick() {

  }

}
