// COMMON-ANGULAR-MODULES

import { ModuleWithProviders } from '@angular/core'

// ROUTING

import { Routes, RouterModule } from '@angular/router';

//IMPORTED-PAGE-COMPONENTS

import { IndexComponent } from './index/index.component';
import { AddproviderComponent} from './addprovider/addprovider.component';
import { ChangepinComponent } from './changepin/changepin.component';
import { EditproviderComponent } from './editprovider/editprovider.component';
import { ManageproviderComponent } from './manageprovider/manageprovider.component';
import { TransactionComponent } from './transaction/transaction.component';
import { AuthGuard } from './../providers/auth.guard';

const ModuleRoutes: Routes = [{
	path: 'forex', component: IndexComponent, canActivate: [AuthGuard],
		children: [
			{path: 'addprovider', component: AddproviderComponent},
			{path: 'changepin', component: ChangepinComponent},
			{path: 'editprovider', component: EditproviderComponent},
			{path: 'manageprovider', component: ManageproviderComponent },
			{path: '', component: TransactionComponent }
		]
	}
];

export const moduleRouting: ModuleWithProviders = RouterModule.forChild(ModuleRoutes)

