import { Injectable } from '@angular/core';

@Injectable({
  providedIn: 'root'
})
export class ValidationService {
  errorList: any[];
  errorCode: any[];

  constructor() {
    this.errorList = [];
    this.errorCode = [];
    this.errorList['ar'] = {
      'required': 'هذه الخانة مطلوبه',
      'email': 'يرجى إدخال البريد الإلكتروني الصحيح',
      'phone': 'يرجى إدخال رقم هاتف صالح',
      'password': 'الرجاء إدخال كلمة السر الصحيحة',
      'minLength': 'الحد الأدنى لطول الحروف هو',
      'maxLength': 'الحد الأقصى لطول الحروف هو',
      'min': 'العمر الأدنى تبدأ في',
      'max': 'العمر القصوى في نهاية',
      'confirm': 'عدم تطابق كلمة المرور'
    };
    this.errorList['en'] = {
      'required': 'This field is required',
      'email': 'Please enter a valid email',
      'phone': 'Please enter a valid phone number',
      'password': 'Please enter a valid password',
      'minLength': 'Minimum characters length is',
      'maxLength': 'Maximum characters length is',
      'min': 'Age min start at ',
      'max': 'Age max end at ',
      'confirm': 'Password mismatch'
    };

    this.errorCode['en'] = {
      'ER01': 'Authentication Failed',
      'ER02': 'Email ID is null or empty',
      'ER03': 'Invalid Email ID',
      'ER04': 'Password is null or empty',
      'ER05': 'Invalid Username / Password',
      'ER06': 'Invalid userType',
      'ER07': 'No record found',
      'ER08': 'Something went wrong',
      'ER09': 'Email and Phone are already exists',
      'ER10': 'Phone no is null or empty',
      'ER11': 'Invalid Phone no',
      'ER12': 'Name no is required',
      'ER13': 'Location no is required',
      'ER14': 'Contact no is required',
      'ER15': 'CR Id is required',
      'ER16': 'CR Manager is required',
      'ER17': 'Provider Id is missing',
      'ER18': 'New Password is missing',
      'ER19': 'User Id is missing',
      'ER20': 'Wrong password',
      'ER21': 'Email is already exists',
      'ER22': 'Phone is already exists',
      'ER23': 'OTP is missing',
      'ER24': 'Invalid OTP',
      'ER25': 'No Currency found',
      'ER26': 'Currency name is missing',
      'ER27': 'Currency symbol is missing',
      'ER28': 'Currency image Id is missing',
      'ER29': 'Currency rate is missing',
      'ER30': 'Currency id is missing',
      'ER31': 'Amount field is missing',
      'ER32': 'SAR amount is missing',
      'ER33': 'User information is required',
      'ER34': 'User id is missing',
      'ER35': 'QR code is required',
      'ER36': 'No transactions found',
      'ER37': 'Transaction id is missing',
      'ER38': 'Driver id is missing',
      'ER39': 'Status is required',
      'ER40': 'Currency Flag is missing',
      'ER41': 'Minimum amount is missing',
      'ER42': 'Unknown user found'
    };

    this.errorCode['ar'] = {
      'ER01': 'المصادقة فشلت',
      'ER02': 'معرف البريد الإلكتروني فارغ أو فارغ',
      'ER03': 'معرف البريد الإلكتروني غير صالح',
      'ER04': 'كلمة المرور فارغة أو فارغة',
      'ER05': 'اسم المتسخدم / كلمة المرور غير صحيحة',
      'ER06': 'نوع المستخدم غير صالح',
      'ER07': 'لا يوجد سجلات',
      'ER08': 'هناك خطأ ما',
      'ER09': 'البريد الإلكتروني والهاتف موجودان بالفعل',
      'ER10': 'رقم الهاتف فارغ أو فارغ',
      'ER11': 'رقم الهاتف غير صالح',
      'ER12': 'الاسم غير مطلوب',
      'ER13': 'الموقع لا مطلوب',
      'ER14': 'لا الاتصال مطلوب',
      'ER15': 'معرف CR مطلوب',
      'ER16': 'مطلوب CR مدير',
      'ER17': 'معرف الموفر مفقود',
      'ER18': 'كلمة المرور الجديدة مفقودة',
      'ER19': 'معرف المستخدم مفقود',
      'ER20': 'كلمة مرور خاطئة',
      'ER21': 'البريد الإلكتروني موجود بالفعل',
      'ER22': 'الهاتف موجود بالفعل',
      'ER23': 'OTP مفقود',
      'ER24': 'غير صالح OTP',
      'ER25': 'لا توجد عملة',
      'ER26': 'اسم العملة مفقود',
      'ER27': 'رمز العملة مفقود',
      'ER28': 'رقم تعريف صورة العملة مفقود',
      'ER29': 'سعر العملة مفقود',
      'ER30': 'معرف العملة مفقود',
      'ER31': 'حقل المبلغ مفقود',
      'ER32': 'مبلغ SAR مفقود',
      'ER33': 'معلومات المستخدم مطلوبة',
      'ER34': 'معرف المستخدم مفقود',
      'ER35': 'مطلوب رمز الاستجابة السريعة',
      'ER36': 'لم يتم العثور على أي معاملات',
      'ER37': 'معرف المعاملة مفقود',
      'ER38': 'معرف السائق مفقود',
      'ER39': 'الحالة مطلوبة',
      'ER40': 'علم العملة مفقود',
      'ER41': 'الحد الأدنى للمبلغ مفقود',
      'ER42': 'تم العثور على مستخدم غير معروف'
    };


  }

  getErrorList() {
    return this.errorList;
  }

  getError(error: any): string {
    if (this.errorList.hasOwnProperty(error.code)) {  // check whether the error code having our definition
      return this.errorList[error.code]; // return our definition
    } else {
      return error.message;
    }
  }
}
