import { Component } from '@angular/core';
import { Router,ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
// import { ModalController } from '@ionic/angular';
// import { ReviewPage} from '../review/review.page';

@Component({
  selector: 'app-booking',
  templateUrl: './booking.page.html',
  styleUrls: ['./booking.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(100%)'}),
        animate('300ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('300ms ease-out', style({transform: 'translateY(100%)'}))
      ])
    ])
  ]
})
export class BookingPage{

  tab:any;
  isShow = false;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) { 

    this.tab = "about";
  }


  goToPage(path,data=null){
    this.router.navigateByUrl(path,{queryParams:data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }


  tab_swap(type) {
    this.tab = type;
   }

   


   istoggle(){
    this.isShow = !this.isShow;
  }


  //  async settings() {
  //   const modal = await this.modalController.create({
  //     component: ReviewPage,
  //     componentProps: { website: 'edupala.com' },
  //     backdropDismiss: false,
  //   });

  //   modal.present();
  // }



}
