import { Component, OnInit } from '@angular/core';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router,ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(100%)'}),
        animate('500ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('500ms ease-out', style({transform: 'translateY(100%)'}))
      ])
    ])
  ]
})
export class LoginPage implements OnInit {
  isShow = false;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
  ) { }

  ngOnInit() {
  }

  istoggle(){
    this.isShow = !this.isShow;
  }


  goToPage(path,data=null){
    this.router.navigateByUrl(path,{queryParams:data});
    
  }

}
