import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-orderdetails',
  templateUrl: './orderdetails.page.html',
  styleUrls: ['./orderdetails.page.scss'],
})
export class OrderdetailsPage implements OnInit {

  shownGroup = null;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) { 

    this.shownGroup = 0;
    console.log(this.shownGroup);
   

  }

  ngOnInit() {
  }



  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }


  isGroupShown(group) {
    return this.shownGroup === group;
  }

  toggleGroup(group) {
    if (this.isGroupShown(group)) {
      this.shownGroup = null;
    } else {
      this.shownGroup = group;
    }
  }
   


}
