import { NgModule } from '@angular/core';
import { PreloadAllModules, RouterModule, Routes } from '@angular/router';

const routes: Routes = [
  {
    path: '',
    redirectTo: 'start',
    pathMatch: 'full'
  },
  {
    path: 'home',
    loadChildren: './home/home.module#HomePageModule'
  },
  {
    path: 'list',
    loadChildren: './list/list.module#ListPageModule'
  },
  { 
    path: 'start',
    loadChildren: './start/start.module#StartPageModule' 
  },
  { 
    path: 'login',
    loadChildren: './login/login.module#LoginPageModule' 
  },
  { 
    path: 'forgot',
    loadChildren: './forgot/forgot.module#ForgotPageModule'
  },
  { 
    path: 'otp',
    loadChildren: './otp/otp.module#OtpPageModule' 
  },
  { 
    path: 'password',
    loadChildren: './password/password.module#PasswordPageModule'
  },
  { 
    path: 'addcar',
    loadChildren: './addcar/addcar.module#AddcarPageModule' 
  },
  { 
    path: 'roadassistance', 
    loadChildren: './roadassistance/roadassistance.module#RoadassistancePageModule'
  },
  { 
    path: 'booking',
    loadChildren: './booking/booking.module#BookingPageModule' 
  },
  { 
    path: 'servicecompleted',
    loadChildren: './servicecompleted/servicecompleted.module#ServicecompletedPageModule'
   },
  { 
    path: 'accepted',
    loadChildren: './accepted/accepted.module#AcceptedPageModule'
  },
  { 
    path: 'review',
    loadChildren: './review/review.module#ReviewPageModule'
  },
  { path: 'waiting', loadChildren: './waiting/waiting.module#WaitingPageModule' },
  { path: 'complete', loadChildren: './complete/complete.module#CompletePageModule' },
  { path: 'profile', loadChildren: './profile/profile.module#ProfilePageModule' },
  { path: 'myservices', loadChildren: './myservices/myservices.module#MyservicesPageModule' },
  { path: 'profilephoto', loadChildren: './profilephoto/profilephoto.module#ProfilephotoPageModule' },
  { path: 'carlist', loadChildren: './carlist/carlist.module#CarlistPageModule' },
  { path: 'servicedetails', loadChildren: './servicedetails/servicedetails.module#ServicedetailsPageModule' },
  { path: 'myorders', loadChildren: './myorders/myorders.module#MyordersPageModule' },
  { path: 'general', loadChildren: './general/general.module#GeneralPageModule' },
  { path: 'settings', loadChildren: './settings/settings.module#SettingsPageModule' },
  { path: 'selectservices', loadChildren: './selectservices/selectservices.module#SelectservicesPageModule' },
  { path: 'date', loadChildren: './date/date.module#DatePageModule' },
  { path: 'summary', loadChildren: './summary/summary.module#SummaryPageModule' },
  { path: 'waiting1', loadChildren: './waiting1/waiting1.module#Waiting1PageModule' },
  { path: 'available', loadChildren: './available/available.module#AvailablePageModule' },
  { path: 'bookservice', loadChildren: './bookservice/bookservice.module#BookservicePageModule' },
  { path: 'cancel', loadChildren: './cancel/cancel.module#CancelPageModule' },
  { path: 'purchaseparts', loadChildren: './purchaseparts/purchaseparts.module#PurchasepartsPageModule' },
  { path: 'productbooking', loadChildren: './productbooking/productbooking.module#ProductbookingPageModule' },
  { path: 'addaddress', loadChildren: './addaddress/addaddress.module#AddaddressPageModule' }
];

@NgModule({
  imports: [
    RouterModule.forRoot(routes, { preloadingStrategy: PreloadAllModules })
  ],
  exports: [RouterModule]
})
export class AppRoutingModule {}
