import { Component } from '@angular/core';
import { Router,ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';

@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(100%)'}),
        animate('300ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('300ms ease-out', style({transform: 'translateY(100%)'}))
      ])
    ])
  ]
})
export class HomePage {

  menuShow = false;
  login= true;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) {}


  goToPage(path,data=null){

    this.router.navigateByUrl(path,{queryParams:data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
    this.logout();
  }

  goBack() {
    this.location.back();
  }

  toLogin(path,data=null){
    this.menuShow = !this.menuShow;
    this.router.navigateByUrl(path,{queryParams:data});
    this.logout();
  }



  menuToggle(){
    this.menuShow = !this.menuShow;
  }

  logout(){
    this.login = !this.login;
  }

}
