//Modules
import { Component, OnInit } from '@angular/core';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router,ActivatedRoute } from '@angular/router';
import {FormGroup,FormBuilder,Validator, Validators,ReactiveFormsModule} from '@angular/forms'
//Plugins
import { Storage } from '@ionic/storage';
//Service
import {BackendApiService} from '../webservices/backend-api.service'

@Component({
  selector: 'app-login',
  templateUrl: './login.page.html',
  styleUrls: ['./login.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(100%)'}),
        animate('500ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('500ms ease-out', style({transform: 'translateY(100%)'}))
      ])
    ])
  ]
})
export class LoginPage implements OnInit {
  isShow = false;
  signupForm:FormGroup;
  loginForm:FormGroup;
  constructor(
    private router: Router,
    private route: ActivatedRoute,
    public storgae:Storage,
    public formbuilder:FormBuilder,
    public service:BackendApiService
  ) {
    this.signupForm = this.formbuilder.group({
      user_name:['',Validators.required],
      user_email:['',Validators.compose([Validators.required,Validators.email])],
      user_phonecode:[''],
      user_phonenumber:['',Validators.required],
      user_country:[''],
      user_address:['',Validators.required],
      user_password:['']
    });
   this.loginForm = this.formbuilder.group({
    user_username:['',Validators.compose([Validators.required, Validators.email])],
    user_password:['',Validators.compose([Validators.required, Validators.minLength(6)])]
   
   });
  }

  ngOnInit() {
  }

  istoggle(){
    this.isShow = !this.isShow;
  }


  goToPage(path,data=null){ //goToPage('home')
    this.router.navigateByUrl(path,{queryParams:data});
    
  }
  login() {
    this.goToPage('home');
      if(this.loginForm.valid) {
        console.log(this.loginForm.value);
       
      } else {
        this.service.presentToast('Something error happend.Sorry');
      }
  }
  signUp() {
   
  }

}
