import { Component, OnInit } from '@angular/core';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router,ActivatedRoute } from '@angular/router';

@Component({
  selector: 'app-servicedetails',
  templateUrl: './servicedetails.page.html',
  styleUrls: ['./servicedetails.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({transform: 'translateY(100%)'}),
        animate('300ms ease-in', style({transform: 'translateY(0%)'}))
      ]),
      transition(':leave', [
        animate('300ms ease-out', style({transform: 'translateY(100%)'}))
      ])
    ])
  ]
})
export class ServicedetailsPage implements OnInit {

  tab:any;
  isShow = false;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location
  ) { 
    this.tab = "detail";
  }

  ngOnInit() {
  }

  tab_swap(type) {
    this.tab = type;
   }


  goToPage(path,data=null){
    this.router.navigateByUrl(path,{queryParams:data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  istoggle(){
    this.isShow = !this.isShow;
  }

}
