import { Component, OnInit, ViewChild, } from '@angular/core';
import { IonSlides } from '@ionic/angular';
import { Router,ActivatedRoute } from '@angular/router';


@Component({
  selector: 'app-start',
  templateUrl: './start.page.html',
  styleUrls: ['./start.page.scss'],
})
export class StartPage implements OnInit {
  @ViewChild(IonSlides) slides: IonSlides;
  currentIndex: any;
  constructor(private router: Router,private route: ActivatedRoute) { }

  ngOnInit() {
  }

  goToPage(path,data=null){
    this.router.navigateByUrl(path,{queryParams:data});
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  slideOpts = {
    initialSlide: 0,
    speed: 1000
  };


  next() {
    this.slides.slideNext();
  }

  prev() {
    this.slides.slidePrev();
  }

   slideChanged() {
    this.slides.getActiveIndex().then(index => {
      this.currentIndex = index;
      console.log(this.currentIndex);

   }); 
  } 

  
}
