import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Platform } from '@ionic/angular';
import { SplashScreen } from '@ionic-native/splash-screen/ngx';
import { StatusBar } from '@ionic-native/status-bar/ngx';
import { AngularFirestore } from '@angular/fire/firestore';
import * as firebase from 'firebase';
import { ModalController } from '@ionic/angular';
import { DeliverypopPage } from './deliverypop/deliverypop.page';
import { AuthService } from './../config/auth.service';
import { ServiceService } from './../config/service.service';
import { SubjectService } from './../config/subject.service';
import { CategoriesService } from './../config/category.service';
import { SearchmodalPage } from './searchmodal/searchmodal.page';
let AppComponent = class AppComponent {
    constructor(platform, splashScreen, statusBar, router, afs, modalController, authService, service, categoryService, subjectService, route) {
        this.platform = platform;
        this.splashScreen = splashScreen;
        this.statusBar = statusBar;
        this.router = router;
        this.afs = afs;
        this.modalController = modalController;
        this.authService = authService;
        this.service = service;
        this.categoryService = categoryService;
        this.subjectService = subjectService;
        this.route = route;
        this.isSearchOpen = false;
        this.sec_active1 = true;
        this.sec_active2 = false;
        this.sec_active3 = false;
        this.sec_active4 = false;
        this.sec_active5 = false;
        this.sec_active6 = false;
        this.tabData = true;
        console.log(this.router.url);
        this.state = true;
        this.initializeApp();
        this.subjectService.getLoginData().subscribe(loginData => {
            this.state = loginData;
        });
        this.subjectService.getUserData().subscribe(userData => {
            if (userData) {
                this.userData = JSON.parse(userData);
                console.log(userData);
                this.orderState();
            }
            else {
                console.log(userData);
            }
        });
        this.subjectService.getTabData().subscribe(tabData => {
            console.log(tabData);
            if (tabData !== null) {
                this.tabData = tabData;
                console.log(this.tabData);
            }
        });
    }
    initializeApp() {
        this.platform.ready().then(() => {
            this.statusBar.styleDefault();
            this.statusBar.hide();
            this.statusBar.overlaysWebView(false);
            this.statusBar.backgroundColorByHexString('#29285b');
        });
    }
    finishpop(data) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: DeliverypopPage,
                componentProps: data
            });
            return yield modal.present();
        });
    }
    fetchCase() {
        const restrictedUrl = [
            '',
            'productdetail',
            'cart',
            'nearby',
            'verification',
            'orderplaced',
            'landing',
            'login',
            'signup',
            'address',
            'forgot',
            'feedback',
            'wishlist',
            'preference',
            'changedetails',
            'trackorder'
        ];
        const currentUrl = this.router.url.split('/');
        const index = restrictedUrl.findIndex(x => x === currentUrl[1]);
        // console.log(currentUrl[1], index, this.state);
        if (index > -1 || this.tabData === false) {
            return true;
        }
        else {
            return false;
        }
    }
    goToPage(path, data = null) {
        this.service.set('params', data);
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    setActive1() {
        this.sec_active1 = true;
        this.sec_active2 = false;
        this.sec_active3 = false;
        this.sec_active4 = false;
        this.sec_active5 = false;
        this.sec_active6 = false;
    }
    setActive2() {
        this.sec_active2 = true;
        this.sec_active1 = false;
        this.sec_active3 = false;
        this.sec_active4 = false;
        this.sec_active5 = false;
        this.sec_active6 = false;
    }
    setActive3() {
        this.sec_active3 = true;
        this.sec_active1 = false;
        this.sec_active2 = false;
        this.sec_active4 = false;
        this.sec_active5 = false;
        this.sec_active6 = false;
    }
    setActive4() {
        this.sec_active4 = true;
        this.sec_active1 = false;
        this.sec_active2 = false;
        this.sec_active3 = false;
        this.sec_active5 = false;
        this.sec_active6 = false;
    }
    setActive5() {
        this.sec_active5 = true;
        this.sec_active1 = false;
        this.sec_active2 = false;
        this.sec_active3 = false;
        this.sec_active4 = false;
        this.sec_active6 = false;
    }
    setActive6() {
        this.sec_active6 = true;
        this.sec_active1 = false;
        this.sec_active2 = false;
        this.sec_active3 = false;
        this.sec_active4 = false;
        this.sec_active5 = false;
    }
    orderState() {
        const custId = this.userData.uid;
        firebase
            .firestore()
            .collection('orders')
            .where('custId', '==', custId)
            .onSnapshot(snapData => {
            snapData.docChanges().forEach(change => {
                if (change.type === 'modified') {
                    const data = change.doc.data();
                    if (data.orderStatus === 7) {
                        this.finishpop(data);
                    }
                }
            });
        });
        /*
    
    
    
        .onSnapshot(function(snapshot) {
            snapshot.docChanges().forEach(function(change) {
                if (change.type === "added") {
                    console.log("New city: ", change.doc.data());
                }
                if (change.type === "modified") {
                    console.log("Modified city: ", change.doc.data());
                }
                if (change.type === "removed") {
                    console.log("Removed city: ", change.doc.data());
                }
            });
        }); */
    }
    vieworder(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    searchModal() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            // Hides Bottom navbar items
            this.isSearchOpen = true;
            const modal = yield this.modalController.create({
                component: SearchmodalPage
            });
            // modal.onDidDismiss().then(dataReturned => {
            //
            // });
            // Shows bottom navbar items on component unmount
            modal.onWillDismiss().then(() => {
                this.isSearchOpen = false;
            });
            return yield modal.present();
        });
    }
};
AppComponent = tslib_1.__decorate([
    Component({
        selector: 'app-root',
        templateUrl: 'app.component.html',
        styleUrls: ['app.component.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Platform,
        SplashScreen,
        StatusBar,
        Router,
        AngularFirestore,
        ModalController,
        AuthService,
        ServiceService,
        CategoriesService,
        SubjectService,
        ActivatedRoute])
], AppComponent);
export { AppComponent };
//# sourceMappingURL=app.component.js.map