import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { ModalController, NavParams } from '@ionic/angular';
import { SearchService } from './../../config/search.service';
import { ServiceService } from './../../config/service.service';
import { ProductsService } from './../../config/products.service';
let SearchmodalPage = class SearchmodalPage {
    constructor(modalController, navParams, searchService, service, productsService, router) {
        this.modalController = modalController;
        this.navParams = navParams;
        this.searchService = searchService;
        this.service = service;
        this.productsService = productsService;
        this.router = router;
        this.searchShow = false;
    }
    ngOnInit() {
        this.searchService.searchList = [];
    }
    closeModal() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield this.modalController.dismiss();
        });
    }
    searchFun(data) {
        this.searchShow = true;
        this.searchService.search(data);
    }
    clickSearch() {
        this.searchShow = true;
        this.searchService.searchList = [];
    }
    viewPage(datas) {
        this.closeModal();
        console.log(datas);
        let data;
        let url;
        if (datas.type === 'shopper') {
            data = datas.data;
            this.service.set('params', data);
            url = 'productlist';
        }
        else if (datas.type === 'category') {
            data = datas.data;
            this.service.set('params', data);
            url = 'catstorelist';
        }
        else {
            data = datas.data;
            data.size = this.service.splitSep(data.size);
            data.tag = this.service.splitSep(data.tag);
            (data.color = this.service.splitSep(data.color)), (url = 'productdetail');
            this.productsService.setProd(data);
        }
        this.searchClose();
        this.router.navigateByUrl(url, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    searchClose() {
        this.closeModal();
        this.searchShow = false;
    }
};
SearchmodalPage = tslib_1.__decorate([
    Component({
        selector: 'app-searchmodal',
        templateUrl: './searchmodal.page.html',
        styleUrls: ['./searchmodal.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [ModalController,
        NavParams,
        SearchService,
        ServiceService,
        ProductsService,
        Router])
], SearchmodalPage);
export { SearchmodalPage };
//# sourceMappingURL=searchmodal.page.js.map