import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { AngularFirestore } from '@angular/fire/firestore';
let AddressService = class AddressService {
    constructor(afs) {
        this.afs = afs;
        this.addressList = [];
    }
    addList(userId) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const This = this;
            const state = true;
            const orderRef = this.afs.collection('address', ref => ref.where('status', '==', state).where('uid', '==', userId));
            orderRef.valueChanges().subscribe(value => {
                this.addressList = [];
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const address = {
                            address: item.address,
                            addressType: item.addressType,
                            latLng: item.latLng,
                            defaultVal: item.defaultVal,
                            building: item.building,
                            landmark: item.landmark,
                            addressId: item.addressId
                        };
                        this.addressList.push(address);
                    });
                    console.log(this.addressList);
                }
                else {
                    // alert('No Orders Found');
                }
            });
        });
    }
    addressCreate(data) {
        console.log(data);
        this.afs
            .collection('address')
            .add({})
            .then(docRef => {
            data.addressId = docRef.id;
            this.afs
                .collection('address')
                .doc(data.addressId)
                .set(data)
                .then(() => {
                this.setDefaultAddress(data.addressId, data.uid);
                // console.log('Address created Successfully');
            });
        });
    }
    setDefaultAddress(addId, userId) {
        this.afs
            .collection('address', ref => ref.where('uid', '==', userId))
            .get()
            .forEach(item => {
            return item.docs.map(m => {
                return this.afs.doc(`address/${m.id}`).update({ defaultVal: 0 });
            });
        });
        setTimeout(() => {
            console.log(addId);
            this.afs
                .collection('address')
                .doc(addId)
                .update({ defaultVal: 1 })
                .then(() => {
                console.log('Address updated Successfully');
            });
        }, 1000);
    }
    deleteAddress(addId) {
        this.afs
            .collection('address')
            .doc(addId)
            .delete();
    }
};
AddressService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore])
], AddressService);
export { AddressService };
//# sourceMappingURL=address.service.js.map