import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { ServiceService } from './../../config/service.service';
import { ShoppersService } from './../../config/shopper.service';
import { SearchService } from '../../config/search.service';
import { trigger, transition, animate, style } from '@angular/animations';
import { ModalController } from '@ionic/angular';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';

@Component({
  selector: 'app-catstorelist',
  templateUrl: './catstorelist.page.html',
  styleUrls: ['./catstorelist.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class CatStorelistPage implements OnInit {
  searchShow = false;
  slideOpts = {
    slidesPerView: 1.5
  };
  data: any;

  constructor(
    public router: Router,
    public location: Location,
    public service: ServiceService,
    public shopperService: ShoppersService,
    private searchService: SearchService,
    private modalController: ModalController,
    private subjectService: SubjectService
  ) {
    this.service.get('params').then(val => {
      this.data = val;
      this.shopperService.shopperList(this.data.catId, 'catId');
    });
  }

  async clickSearch() {
    this.subjectService.setTabData(false);
    const modal = await this.modalController.create({
      component: SearchmodalPage
    });
    modal.onDidDismiss().then(dataReturned => {
      this.subjectService.setTabData(true);
    });
    return await modal.present();
  }

  searchClose() {
    this.searchShow = false;
  }
  ngOnInit() {}

  goToPage(path, data = null) {
    this.service.set('params', data);
    this.router.navigateByUrl(path, { queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }
}
