import { Injectable } from '@angular/core';
import { Storage } from '@ionic/storage';
import { ToastController } from '@ionic/angular';

@Injectable({
  providedIn: 'root'
})
export class ServiceService {
  state: boolean;

  constructor(
    public storage: Storage,
    public toastController: ToastController
  ) {
    this.state = true;
  }

  public set(settingName: string, value: any) {
    return this.storage.set(`setting:${settingName}`, value);
  }

  public async get(settingName: string) {
    return await this.storage.get(`setting:${settingName}`);
  }

  public async remove(settingName: string) {
    return await this.storage.remove(`setting:${settingName}`);
  }

  public clear() {
    this.storage.clear().then(() => {
      console.log('all keys cleared');
    });
  }

  public key2Array(item: object) {
    const response = [];
    for (const key in item) {
      if (item.hasOwnProperty(key)) {
        response.push(item[key]);
      }
    }
    return response;
  }

  public splitSep(item: object) {
    const response = [];
    for (const key in item) {
      if (item.hasOwnProperty(key)) {
        response.push(key);
      }
    }
    return response;
  }

  showToast(msg, positions, className, durations = 2000) {
    try {
      const promise1 = new Promise((resolve, reject) => {
        this.toastController
          .create({
            message: msg,
            duration: durations,
            position: positions,
            cssClass: className
          })
          .then(res => {
            res.present();
            resolve(true);
          });
      });
      return promise1;
    } catch (error) {
      console.log('error: ' + error);
    }
  }
}
