import { Injectable } from '@angular/core';
import { AngularFireAuth } from '@angular/fire/auth';
import {
  AngularFirestore,
  AngularFirestoreDocument,
  AngularFirestoreCollection
} from '@angular/fire/firestore';
import * as firebase from 'firebase';
import { User } from './services/user';

@Injectable({
  providedIn: 'root'
})

// Gets User Details
export class UserService {
  users: User;
  constructor(public afs: AngularFirestore, public afAuth: AngularFireAuth) { }

  public async getUserData(userId: string) {
    const This = this;
    const state = true;

    // Get User Query
    const userRef: AngularFirestoreCollection<any> = this.afs.collection(
      'customers',
      ref => ref.where('uid', '==', userId).where('status', '==', state)
    );
    userRef.valueChanges().subscribe(value => {
      const res = value;
      if (res.length > 0) {
        const item = res[0];
        this.users = {
          name: item.name,
          emailId: item.emailId,
          phone: item.phone,
          uid: item.uid,
          profilePhoto: item.profilePic,
          status: item.status,
          phoneVerified: item.phoneVerified,
          emailVerified: item.emailVerified,
          loginType: 0,
          otp: '',
          currency: {
            currId: '',
            currName: '',
            symbol: ''
          }
        };
      }
      //   return this.users;
    });
  }
}
