import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { AddressService } from './../../config/address.service';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { ServiceService } from './../../config/service.service';
let AddressPage = class AddressPage {
    constructor(location, addressService, router, service) {
        this.location = location;
        this.addressService = addressService;
        this.router = router;
        this.service = service;
        this.loader = false;
        const users = this.service.get('user').then(data => {
            if (data) {
                data = JSON.parse(data);
                this.custId = data.uid;
                this.addressService.addList(data.uid);
            }
        });
    }
    ngOnInit() { }
    goBack() {
        this.location.back();
    }
    setDefault(addressId) {
        this.loader = true;
        console.log(addressId);
        this.addressService.setDefaultAddress(addressId, this.custId).then(() => {
            this.loader = false;
        }).catch(err => {
            this.loader = false;
            this.service.showToast('Something went wrong please try again!', 'top', 'my-error', 1000);
        });
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
};
AddressPage = tslib_1.__decorate([
    Component({
        selector: 'app-address',
        templateUrl: './address.page.html',
        styleUrls: ['./address.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Location,
        AddressService,
        Router,
        ServiceService])
], AddressPage);
export { AddressPage };
//# sourceMappingURL=address.page.js.map