import * as tslib_1 from "tslib";
import { Component, ViewChild } from '@angular/core';
import { IonSlides } from '@ionic/angular';
import { Router, ActivatedRoute } from '@angular/router';
import { ServiceService } from './../../config/service.service';
import { SubjectService } from './../../config/subject.service';
let LandingPage = class LandingPage {
    constructor(router, route, service, subjectService) {
        this.router = router;
        this.route = route;
        this.service = service;
        this.subjectService = subjectService;
        this.slideOpts = {
            initialSlide: 0,
            speed: 1000,
            allowTouchMove: false
        };
        this.landingOptions = {
            initialSlide: 1,
            speed: 1000,
            allowTouchMove: true
        };
    }
    ngOnInit() { }
    goToPage(path, data = null) {
        this.service.set('landing', true);
        this.router.navigateByUrl(path, { replaceUrl: true, queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    next() {
        this.slides.slideNext();
    }
    prev() {
        this.slides.slidePrev();
    }
    slideChanged() {
        this.slides.getActiveIndex().then(index => {
            this.currentIndex = index;
            console.log(this.currentIndex);
        });
    }
};
tslib_1.__decorate([
    ViewChild(IonSlides, { static: false }),
    tslib_1.__metadata("design:type", IonSlides)
], LandingPage.prototype, "slides", void 0);
LandingPage = tslib_1.__decorate([
    Component({
        selector: 'app-landing',
        templateUrl: './landing.page.html',
        styleUrls: ['./landing.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        ServiceService,
        SubjectService])
], LandingPage);
export { LandingPage };
//# sourceMappingURL=landing.page.js.map