import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { AuthService } from './../../config/auth.service';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
let SignupPage = class SignupPage {
    constructor(router, route, location, register) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.register = register;
        this.menuShow = false;
        this.currDate = new Date();
        this.mobnumPattern = '((+61)|+61|(0[1-9])|0[1-9])?( ?-?[0-9]){6,10}';
        this.signup = {
            emailId: '',
            name: '',
            password: '',
            phone: '',
            dob: '',
            terms: false
        };
        this.submitted = false;
        console.log(this.currDate.getFullYear() - 10);
        this.currDate.setFullYear(this.currDate.getFullYear() - 10);
        console.log(this.currDate);
        const month = this.currDate.getMonth() + 1 < 10 ? '0' + (this.currDate.getMonth() + 1) : '' + (this.currDate.getMonth() + 1), day = this.currDate.getDate() < 10 ? '0' + this.currDate.getDate() : this.currDate.getDate(), year = this.currDate.getFullYear();
        this.minDate = [year, month, day].join('-');
    }
    ngOnInit() { }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { replaceUrl: true, queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    menuToggle() {
        this.menuShow = !this.menuShow;
    }
    onSignup(form) {
        this.submitted = true;
        console.log(form.value);
        if (form.valid) {
            console.log(form.value);
            this.register.signup(form.value);
        }
    }
};
SignupPage = tslib_1.__decorate([
    Component({
        selector: 'app-signup',
        templateUrl: './signup.page.html',
        styleUrls: ['./signup.page.scss'],
        animations: [
            trigger('slideInOut', [
                transition(':enter', [
                    style({ transform: 'translateY(100%)' }),
                    animate('300ms ease-in', style({ transform: 'translateY(0%)' }))
                ]),
                transition(':leave', [
                    animate('300ms ease-out', style({ transform: 'translateY(100%)' }))
                ])
            ])
        ]
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        AuthService])
], SignupPage);
export { SignupPage };
//# sourceMappingURL=signup.page.js.map