import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { AngularFirestore } from '@angular/fire/firestore';
let SearchService = class SearchService {
    constructor(afs) {
        this.afs = afs;
        this.searchList = [];
    }
    search(inputText) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            if (inputText === '') {
                this.searchList = [];
                return;
            }
            const This = this;
            const state = true;
            this.searchList = [];
            // tslint:disable-next-line:max-line-length
            const orderRef = this.afs.collection('shoppers', ref => ref
                .where('status', '==', state)
                .orderBy('searchName')
                .startAt(inputText.toLowerCase())
                .endAt(inputText.toLowerCase() + '\uf8ff')
                .limit(5));
            orderRef.valueChanges().subscribe(value => {
                const res = value;
                if (res.length > 0) {
                    res.forEach(item => {
                        // console.log(item);
                        const shopper = {
                            text: item.name,
                            data: item,
                            type: 'shopper'
                        };
                        this.searchList.push(shopper);
                    });
                }
            });
            // tslint:disable-next-line:max-line-length
            const prodRef = this.afs.collection('products', ref => ref
                .where('status', '==', state)
                .orderBy('searchName')
                .startAt(inputText.toLowerCase())
                .endAt(inputText.toLowerCase() + '\uf8ff')
                .limit(5));
            prodRef.valueChanges().subscribe(values => {
                const result = values;
                if (result.length > 0) {
                    result.forEach(item => {
                        console.log(item);
                        const prod = {
                            text: item.prodName,
                            data: item,
                            type: 'product'
                        };
                        this.searchList.push(prod);
                    });
                    console.log(this.searchList);
                }
            });
            // tslint:disable-next-line:max-line-length
            const feaRef = this.afs.collection('shopcategory', ref => ref
                .where('status', '==', state)
                .orderBy('searchName')
                .startAt(inputText.toLowerCase())
                .endAt(inputText.toLowerCase() + '\uf8ff')
                .limit(5));
            feaRef.valueChanges().subscribe(values => {
                const result = values;
                if (result.length > 0) {
                    result.forEach(item => {
                        console.log(item);
                        const prod = {
                            text: item.catName,
                            data: item,
                            type: 'category'
                        };
                        this.searchList.push(prod);
                    });
                    console.log(this.searchList);
                }
            });
        });
    }
};
SearchService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore])
], SearchService);
export { SearchService };
//# sourceMappingURL=search.service.js.map