import { Component, OnInit } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { NgForm } from '@angular/forms';
import { AuthService } from './../../config/auth.service';
import { Location } from '@angular/common';
import { trigger, transition, animate, style } from '@angular/animations';
import { Signup } from './../../config/services/user';

@Component({
  selector: 'app-signup',
  templateUrl: './signup.page.html',
  styleUrls: ['./signup.page.scss'],
  animations: [
    trigger('slideInOut', [
      transition(':enter', [
        style({ transform: 'translateY(100%)' }),
        animate('300ms ease-in', style({ transform: 'translateY(0%)' }))
      ]),
      transition(':leave', [
        animate('300ms ease-out', style({ transform: 'translateY(100%)' }))
      ])
    ])
  ]
})
export class SignupPage implements OnInit {
  menuShow = false;
  currDate = new Date();
  mobnumPattern = '((+61)|+61|(0[1-9])|0[1-9])?( ?-?[0-9]){6,10}';
  minDate: any;
  signup: Signup = {
    emailId: '',
    name: '',
    password: '',
    phone: '',
    dob: '',
    terms: false
  };
  submitted = false;

  constructor(
    private router: Router,
    private route: ActivatedRoute,
    private location: Location,
    public register: AuthService
  ) {
    console.log(this.currDate.getFullYear() - 10);
    this.currDate.setFullYear(this.currDate.getFullYear() - 10);
    console.log(this.currDate);
    const month = this.currDate.getMonth() + 1 < 10 ? '0' + (this.currDate.getMonth() + 1) : '' + (this.currDate.getMonth() + 1),
      day = this.currDate.getDate() < 10 ? '0' + this.currDate.getDate() : this.currDate.getDate(),
      year = this.currDate.getFullYear();
    this.minDate = [year, month, day].join('-');
  }

  ngOnInit() { }

  goToPage(path, data = null) {
    this.router.navigateByUrl(path, { replaceUrl: true, queryParams: data });
    document.body.scrollTop = document.documentElement.scrollTop = 0;
  }

  goBack() {
    this.location.back();
  }

  menuToggle() {
    this.menuShow = !this.menuShow;
  }

  onSignup(form: NgForm) {
    this.submitted = true;
    console.log(form.value);
    if (form.valid) {
      console.log(form.value);
      this.register.signup(form.value);
    }
  }
}
