import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { CategoriesService } from './../../config/category.service';
import { ServiceService } from './../../config/service.service';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';
import { ModalController } from '@ionic/angular';
let CatagoryPage = class CatagoryPage {
    constructor(router, location, categoriesService, service, subjectService, modalController) {
        this.router = router;
        this.location = location;
        this.categoriesService = categoriesService;
        this.service = service;
        this.subjectService = subjectService;
        this.modalController = modalController;
        /* this.service.get('catParams').then((val) => {
          this.data = val;
        }); */
    }
    ngOnInit() {
    }
    goToPage(path, data = null) {
        this.service.set('catParams', data);
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goToSearch(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    searchModal() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.subjectService.setTabData(false);
            const modal = yield this.modalController.create({
                component: SearchmodalPage
            });
            modal.onDidDismiss().then(dataReturned => {
                this.subjectService.setTabData(true);
            });
            return yield modal.present();
        });
    }
};
CatagoryPage = tslib_1.__decorate([
    Component({
        selector: 'app-catagory',
        templateUrl: './catagory.page.html',
        styleUrls: ['./catagory.page.scss'],
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        Location,
        CategoriesService,
        ServiceService,
        SubjectService,
        ModalController])
], CatagoryPage);
export { CatagoryPage };
//# sourceMappingURL=catagory.page.js.map