import * as tslib_1 from "tslib";
import { Component, NgZone } from '@angular/core';
import { Location } from '@angular/common';
import { Router, ActivatedRoute } from '@angular/router';
import { MapsAPILoader } from '@agm/core';
import { Address } from './../../config/services/address';
import { AddressService } from './../../config/address.service';
import { ServiceService } from './../../config/service.service';
import { AuthService } from './../../config/auth.service';
import * as firebase from 'firebase';
/* import { google } from '@agm/core/services/google-maps-types'; */
let NearbyPage = class NearbyPage {
    constructor(router, route, location, mapsAPILoader, ngZone, addressService, service, authService) {
        this.router = router;
        this.route = route;
        this.location = location;
        this.mapsAPILoader = mapsAPILoader;
        this.ngZone = ngZone;
        this.addressService = addressService;
        this.service = service;
        this.authService = authService;
        this.addressData = new Address('', '', '', '', true, '', 0, '');
        this.successState = false;
        this.type = 0;
        const users = this.service.get('user').then(data => {
            if (data) {
                data = JSON.parse(data);
                this.uid = data.uid;
            }
        });
        this.service.get('type').then(data => {
            this.type = data;
        });
    }
    ngOnInit() {
        // load Places Autocomplete
        this.mapsAPILoader.load().then(() => {
            this.setCurrentLocation();
            this.geoCoder = new google.maps.Geocoder();
        });
    }
    // google maps zoom level
    setCurrentLocation() {
        console.log('map-called');
        if ('geolocation' in navigator) {
            console.log(navigator);
            this.latitude = -33.87276;
            this.longitude = 151.20534;
            this.zoom = 8;
            this.getAddress(this.latitude, this.longitude);
            navigator.geolocation.getCurrentPosition(position => {
                this.latitude = position.coords.latitude;
                this.longitude = position.coords.longitude;
                this.zoom = 8;
                this.getAddress(this.latitude, this.longitude);
            });
        }
    }
    markerDragEnd($event) {
        console.log($event);
        this.latitude = $event.coords.lat;
        this.longitude = $event.coords.lng;
        this.getAddress(this.latitude, this.longitude);
    }
    getAddress(latitude, longitude) {
        this.geoCoder = new google.maps.Geocoder();
        this.geoCoder.geocode({ location: { lat: latitude, lng: longitude } }, (results, status) => {
            console.log(results);
            console.log(status);
            if (status === 'OK') {
                if (results[0]) {
                    this.zoom = 12;
                    this.address = results[0].formatted_address;
                    console.log(this.address);
                }
                else {
                    console.log('No results found');
                }
            }
            else {
                console.log('Geocoder failed due to: ' + status);
            }
        });
    }
    mapReady(map) {
        map.addListener('dragend', () => {
            console.log(this.newCenterLat, this.newCenterLng);
            this.getAddress(this.newCenterLat, this.newCenterLng);
        });
    }
    centerChange(e) {
        console.log(e);
        this.newCenterLat = e.lat;
        this.newCenterLng = e.lng;
        this.getAddress(this.newCenterLat, this.newCenterLng);
    }
    goToPage(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        window.history.back();
    }
    onSubmit(data) {
        this.loader = true;
        console.log(data);
        const postData = {
            address: this.address,
            addressType: data.addressType,
            building: data.building,
            landmark: data.landmark,
            defaultVal: 0,
            uid: this.uid,
            latLng: new firebase.firestore.GeoPoint(this.newCenterLat, this.newCenterLat),
            status: true
        };
        this.addressService.addressCreate(postData);
        this.successState = true;
        setTimeout(() => {
            this.loader = false;
            this.successState = false;
            if (this.authService.regState === false) {
                this.router.navigateByUrl('preference', { queryParams: null });
            }
            else {
                if (this.addressService.addressState === 1) {
                    this.addressService.addressState = 0;
                    this.router.navigateByUrl('cart', { replaceUrl: true });
                }
                else {
                    this.goBack();
                }
            }
        }, 3000);
    }
};
NearbyPage = tslib_1.__decorate([
    Component({
        selector: 'app-nearby',
        templateUrl: './nearby.page.html',
        styleUrls: ['./nearby.page.scss']
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        ActivatedRoute,
        Location,
        MapsAPILoader,
        NgZone,
        AddressService,
        ServiceService,
        AuthService])
], NearbyPage);
export { NearbyPage };
//# sourceMappingURL=nearby.page.js.map