import * as tslib_1 from "tslib";
import { Component } from '@angular/core';
import { trigger, transition, animate, style } from '@angular/animations';
import { Router } from '@angular/router';
import { Location } from '@angular/common';
import { ServiceService } from './../../config/service.service';
import { ShoppersService } from './../../config/shopper.service';
import { SearchService } from '../../config/search.service';
import { ModalController } from '@ionic/angular';
import { SearchmodalPage } from '../searchmodal/searchmodal.page';
import { SubjectService } from './../../config/subject.service';
let StorelistPage = class StorelistPage {
    constructor(router, location, service, shopperService, searchService, modalController, subjectService) {
        this.router = router;
        this.location = location;
        this.service = service;
        this.shopperService = shopperService;
        this.searchService = searchService;
        this.modalController = modalController;
        this.subjectService = subjectService;
        this.searchShow = false;
        this.slideOpts = {
            slidesPerView: 1.5
        };
        this.loader = true;
        this.service.get('centerParams').then(val => {
            this.data = val;
            this.centerId = this.data.cId;
            this.shopperService.shopperList(this.data.cId, 'centerId');
            setTimeout(() => {
                this.loader = false;
            }, 2000);
        });
    }
    ngOnInit() { }
    goToPage(path, data = null) {
        this.service.set('shopParams', data);
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goToSearch(path, data = null) {
        this.router.navigateByUrl(path, { queryParams: data });
        document.body.scrollTop = document.documentElement.scrollTop = 0;
    }
    goBack() {
        this.location.back();
    }
    clickSearch() {
        this.searchShow = true;
        this.searchService.searchList = [];
    }
    searchModal() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            this.subjectService.setTabData(false);
            const modal = yield this.modalController.create({
                component: SearchmodalPage
            });
            modal.onDidDismiss().then(dataReturned => {
                this.subjectService.setTabData(true);
            });
            return yield modal.present();
        });
    }
    searchClose() {
        this.searchShow = false;
    }
    filterFunction(featuredStore) {
        return featuredStore.filter(store => store.centerId === this.centerId);
    }
};
StorelistPage = tslib_1.__decorate([
    Component({
        selector: 'app-storelist',
        templateUrl: './storelist.page.html',
        styleUrls: ['./storelist.page.scss'],
        animations: [
            trigger('slideInOut', [
                transition(':enter', [
                    style({ transform: 'translateY(100%)' }),
                    animate('200ms ease-in', style({ transform: 'translateY(0%)' }))
                ]),
                transition(':leave', [
                    animate('200ms ease-out', style({ transform: 'translateY(100%)' }))
                ])
            ])
        ]
    }),
    tslib_1.__metadata("design:paramtypes", [Router,
        Location,
        ServiceService,
        ShoppersService,
        SearchService,
        ModalController,
        SubjectService])
], StorelistPage);
export { StorelistPage };
//# sourceMappingURL=storelist.page.js.map