import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { AngularFirestore } from '@angular/fire/firestore';
import { ServiceService } from './service.service';
import { Router } from '@angular/router';
let FeedbackService = class FeedbackService {
    constructor(afs, router, service) {
        this.afs = afs;
        this.router = router;
        this.service = service;
        this.loader = false;
    }
    feedbackCreate(data) {
        this.loader = true;
        this.afs
            .collection('feedback')
            .add({})
            .then(docRef => {
            data.feedbackId = docRef.id;
            this.afs
                .collection('feedback')
                .doc(data.feedbackId)
                .set(data)
                .then(() => {
                this.service
                    .showToast('Thank you for your feedback!', 'top', 'my-toast', 2000)
                    .then(() => {
                    this.loader = false;
                    setTimeout(() => {
                        this.router.navigateByUrl('home');
                    }, 2100);
                })
                    .catch(err => {
                    this.loader = false;
                });
            });
        });
    }
};
FeedbackService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [AngularFirestore,
        Router,
        ServiceService])
], FeedbackService);
export { FeedbackService };
//# sourceMappingURL=feedback.service.js.map