import * as tslib_1 from "tslib";
import { Injectable } from '@angular/core';
import { Storage } from '@ionic/storage';
import { ToastController } from '@ionic/angular';
import * as firebase from 'firebase';
let ServiceService = class ServiceService {
    constructor(storage, toastController) {
        this.storage = storage;
        this.toastController = toastController;
        this.state = true;
        this.distance = 10;
        this.storage.ready().then(() => {
            this.get('user');
        });
        this.setting().then((data) => {
            if (data) {
                this.distance = data;
            }
        }).catch(err => {
            this.distance = 10;
        });
    }
    set(settingName, value) {
        return this.storage.set(`setting:${settingName}`, value);
    }
    get(settingName) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield this.storage.get(`setting:${settingName}`);
        });
    }
    remove(settingName) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield this.storage.remove(`setting:${settingName}`);
        });
    }
    clear() {
        this.storage.clear().then(() => {
            console.log('all keys cleared');
        });
    }
    key2Array(item) {
        const response = [];
        for (const key in item) {
            if (item.hasOwnProperty(key)) {
                response.push(item[key]);
            }
        }
        return response;
    }
    splitSep(item) {
        const response = [];
        for (const key in item) {
            if (item.hasOwnProperty(key)) {
                response.push(key);
            }
        }
        return response;
    }
    showToast(msg, positions, className, durations = 2000) {
        try {
            const promise1 = new Promise((resolve, reject) => {
                this.toastController
                    .create({
                    message: msg,
                    duration: durations,
                    position: positions,
                    cssClass: className
                })
                    .then(res => {
                    res.present();
                    resolve(true);
                });
            });
            return promise1;
        }
        catch (error) {
            console.log('error: ' + error);
        }
    }
    formatNumber(num) {
        return num.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1,');
    }
    setting() {
        const promise = new Promise(resolve => {
            const prodRef = firebase
                .firestore()
                .collection('setting')
                .doc('basic').onSnapshot(doc => {
                console.log(doc.data());
                if (doc.exists) {
                    const data = doc.data();
                    this.distance = data.distance;
                    resolve(this.distance);
                }
            });
        });
        return promise;
    }
    getBase64ImageFromUrl(imageUrl) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const proxyUrl = 'https://cors-anywhere.herokuapp.com/';
            const res = yield fetch(proxyUrl + imageUrl);
            const blob = yield res.blob();
            return new Promise((resolve, reject) => {
                const reader = new FileReader();
                reader.addEventListener('load', () => {
                    resolve(reader.result);
                }, false);
                reader.onerror = () => {
                    return reject(this);
                };
                reader.readAsDataURL(blob);
            });
        });
    }
};
ServiceService = tslib_1.__decorate([
    Injectable({
        providedIn: 'root'
    }),
    tslib_1.__metadata("design:paramtypes", [Storage,
        ToastController])
], ServiceService);
export { ServiceService };
//# sourceMappingURL=service.service.js.map